/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.compile.core.processor.annotation;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.griffon.compile.core.AnnotationHandler;
import org.kordamp.jipsy.processor.Initializer;
import org.kordamp.jipsy.processor.LogLocation;
import org.kordamp.jipsy.processor.Logger;

public final class AnnotationHandlerCollector {
    private final Map<String, String> handlers = new TreeMap<String, String>();
    private final Map<String, String> cached = new TreeMap<String, String>();
    private final Initializer initializer;
    private final Logger logger;

    public AnnotationHandlerCollector(Initializer initializer, Logger logger) {
        this.initializer = initializer;
        this.logger = logger;
    }

    public boolean isModified() {
        if (this.cached.size() != this.handlers.size()) {
            return true;
        }
        for (Map.Entry<String, String> entry : this.cached.entrySet()) {
            if (!this.handlers.containsKey(entry.getKey())) {
                return true;
            }
            if (entry.getValue().equals(this.handlers.get(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    public String getAnnotationHandler(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("type");
        }
        if (!this.handlers.containsKey(string)) {
            this.handlers.put(string, string2);
        }
        return this.handlers.get(string);
    }

    public void load() {
        CharSequence charSequence = this.initializer.initialData(AnnotationHandler.class.getName());
        if (charSequence != null) {
            this.fromList(charSequence.toString());
        }
        this.cached.putAll(this.handlers);
    }

    public void removeAnnotationHandler(String string) {
        if (string == null) {
            throw new NullPointerException("type");
        }
        this.logger.note(LogLocation.LOG_FILE, "Removing " + string);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string2 : this.handlers.keySet()) {
            if (!string.equals(this.handlers.get(string2))) continue;
            linkedHashSet.add(string2);
        }
        for (String string2 : linkedHashSet) {
            this.handlers.remove(string2);
        }
    }

    public String toString() {
        return this.handlers.toString();
    }

    public String toList() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.handlers.entrySet()) {
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }

    public Map<String, String> handlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    public void fromList(String string) {
        String[] stringArray;
        if (string == null) {
            throw new NullPointerException("input");
        }
        for (String string2 : stringArray = string.split("\\n")) {
            if (string2.startsWith("#") || string2.trim().length() <= 0) continue;
            String[] stringArray2 = string2.trim().split("=");
            this.handlers.put(stringArray2[0], stringArray2[1]);
        }
    }
}

