/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.compile.core.processor.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.griffon.compile.core.processor.artifact.Artifact;
import org.kordamp.jipsy.processor.Initializer;
import org.kordamp.jipsy.processor.LogLocation;
import org.kordamp.jipsy.processor.Logger;

public final class ArtifactCollector {
    private final Map<String, Artifact> artifacts = new LinkedHashMap<String, Artifact>();
    private final Map<String, Artifact> cached = new LinkedHashMap<String, Artifact>();
    private final List<String> removed = new ArrayList<String>();
    private final Initializer initializer;
    private final Logger logger;

    public ArtifactCollector(Initializer initializer, Logger logger) {
        this.initializer = initializer;
        this.logger = logger;
    }

    public void cache() {
        this.cached.putAll(this.artifacts);
    }

    public boolean isModified() {
        if (this.cached.size() != this.artifacts.size()) {
            return true;
        }
        for (Map.Entry<String, Artifact> entry : this.cached.entrySet()) {
            if (!this.artifacts.containsKey(entry.getKey())) {
                return true;
            }
            if (entry.getValue().equals(this.artifacts.get(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    public Artifact getArtifact(String string) {
        if (string == null) {
            throw new NullPointerException("artifact");
        }
        if (!this.artifacts.containsKey(string)) {
            Artifact artifact = new Artifact(this.logger, string);
            CharSequence charSequence = this.initializer.initialData(string);
            if (charSequence != null) {
                artifact.fromProviderNamesList(charSequence.toString());
                for (String string2 : this.removed) {
                    artifact.removeProvider(string2);
                }
            }
            this.artifacts.put(string, artifact);
        }
        return this.artifacts.get(string);
    }

    public Collection<Artifact> artifacts() {
        return Collections.unmodifiableMap(this.artifacts).values();
    }

    public void removeProvider(String string) {
        if (string == null) {
            throw new NullPointerException("provider");
        }
        this.logger.note(LogLocation.LOG_FILE, "Removing " + string);
        this.removed.add(string);
        for (Artifact artifact : this.artifacts.values()) {
            artifact.removeProvider(string);
        }
    }

    public String toString() {
        return this.artifacts.values().toString();
    }
}

