/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.compile.core.processor.editor;

import java.beans.PropertyEditor;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import org.kordamp.jipsy.processor.Initializer;
import org.kordamp.jipsy.processor.LogLocation;
import org.kordamp.jipsy.processor.Logger;

public final class PropertyEditorCollector {
    private final Map<String, String> editors = new TreeMap<String, String>();
    private final Map<String, String> cached = new TreeMap<String, String>();
    private final Initializer initializer;
    private final Logger logger;

    public PropertyEditorCollector(Initializer initializer, Logger logger) {
        this.initializer = initializer;
        this.logger = logger;
    }

    public String getPropertyEditor(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("type");
        }
        if (!this.editors.containsKey(string)) {
            this.editors.put(string, string2);
        }
        return this.editors.get(string);
    }

    public boolean isModified() {
        if (this.cached.size() != this.editors.size()) {
            return true;
        }
        for (Map.Entry<String, String> entry : this.cached.entrySet()) {
            if (!this.editors.containsKey(entry.getKey())) {
                return true;
            }
            if (entry.getValue().equals(this.editors.get(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    public void load() {
        CharSequence charSequence = this.initializer.initialData(PropertyEditor.class.getName());
        if (charSequence != null) {
            this.fromList(charSequence.toString());
        }
        this.cached.putAll(this.editors);
    }

    public void removePropertyEditor(String string) {
        if (string == null) {
            throw new NullPointerException("type");
        }
        this.logger.note(LogLocation.LOG_FILE, "Removing " + string);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string2 : this.editors.keySet()) {
            if (!string.equals(this.editors.get(string2))) continue;
            linkedHashSet.add(string2);
        }
        for (String string2 : linkedHashSet) {
            this.editors.remove(string2);
        }
    }

    public String toString() {
        return this.editors.toString();
    }

    public String toList() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.editors.entrySet()) {
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }

    public Map<String, String> editors() {
        return Collections.unmodifiableMap(this.editors);
    }

    public void fromList(String string) {
        String[] stringArray;
        if (string == null) {
            throw new NullPointerException("input");
        }
        for (String string2 : stringArray = string.split("\\n")) {
            if (string2.startsWith("#") || string2.trim().length() <= 0) continue;
            String[] stringArray2 = string2.trim().split("=");
            this.editors.put(stringArray2[0], stringArray2[1]);
        }
    }
}

