/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.compile.core.processor.editor;

import griffon.metadata.PropertyEditorFor;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.codehaus.griffon.compile.core.processor.editor.PropertyEditorCollector;
import org.codehaus.griffon.compile.core.processor.editor.PropertyEditorPersistence;
import org.kordamp.jipsy.processor.AbstractSpiProcessor;
import org.kordamp.jipsy.processor.CheckResult;
import org.kordamp.jipsy.processor.LogLocation;
import org.kordamp.jipsy.processor.Persistence;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"spi_dir", "spi_log", "spi_verbose", "spi_disabled"})
public class PropertyEditorProcessor
extends AbstractSpiProcessor {
    public static final String NAME = PropertyEditorProcessor.class.getName() + " (" + PropertyEditorProcessor.class.getPackage().getImplementationVersion() + ")";
    private static final int MAX_SUPPORTED_VERSION = 8;
    private Persistence persistence;
    private PropertyEditorCollector data;
    private TypeElement propertyEditorType;

    public SourceVersion getSupportedSourceVersion() {
        SourceVersion[] sourceVersionArray = SourceVersion.values();
        for (int i = sourceVersionArray.length - 1; i >= 0; --i) {
            int n;
            String string = sourceVersionArray[i].name();
            Matcher matcher = RELEASE_PATTERN.matcher(string);
            if (!matcher.matches() || (n = Integer.parseInt(matcher.group(1))) > 8) continue;
            return sourceVersionArray[i];
        }
        return SourceVersion.RELEASE_6;
    }

    protected Class<? extends Annotation> getAnnotationClass() {
        return PropertyEditorFor.class;
    }

    protected void initialize() {
        super.initialize();
        this.persistence = new PropertyEditorPersistence(NAME, this.options.dir(), this.processingEnv.getFiler(), this.logger);
        this.propertyEditorType = this.processingEnv.getElementUtils().getTypeElement(PropertyEditor.class.getName());
        this.data = new PropertyEditorCollector(this.persistence.getInitializer(), this.logger);
        this.data.load();
    }

    protected void handleElement(Element element) {
        if (!(element instanceof TypeElement)) {
            return;
        }
        TypeElement typeElement = (TypeElement)element;
        CheckResult checkResult = this.checkCurrentClass(typeElement);
        if (checkResult.isError()) {
            this.reportError(typeElement, checkResult);
            return;
        }
        for (TypeElement typeElement2 : this.findTypes(typeElement)) {
            CheckResult checkResult2 = this.isImplementation(typeElement, this.propertyEditorType);
            if (checkResult2.isError()) {
                this.reportError(typeElement, checkResult2);
                continue;
            }
            this.register(this.createProperQualifiedName(typeElement2), typeElement);
        }
    }

    protected void removeStaleData(RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getRootElements()) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            this.data.removePropertyEditor(this.createProperQualifiedName(typeElement));
        }
    }

    protected void writeData() {
        if (this.data.isModified()) {
            String string = this.data.toList();
            if (string.length() > 0) {
                this.logger.note(LogLocation.LOG_FILE, "Writing output");
                try {
                    this.persistence.write(PropertyEditor.class.getName(), string);
                }
                catch (IOException iOException) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, iOException.getMessage());
                }
                this.persistence.writeLog();
            } else {
                this.logger.note(LogLocation.LOG_FILE, "Writing output");
                try {
                    this.persistence.delete();
                }
                catch (IOException iOException) {
                    this.logger.warning(LogLocation.LOG_FILE, "An error occurred while deleting data file");
                }
            }
        }
    }

    private CheckResult checkCurrentClass(TypeElement typeElement) {
        if (typeElement.getKind() != ElementKind.CLASS) {
            return CheckResult.valueOf((String)"is not a class");
        }
        if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return CheckResult.valueOf((String)"is not a public class");
        }
        if (this.isAbstractClass(typeElement)) {
            return CheckResult.valueOf((String)"is an abstract class");
        }
        if (!this.hasPublicNoArgsConstructor(typeElement)) {
            return CheckResult.valueOf((String)"has no public no-args constructor");
        }
        return CheckResult.OK;
    }

    private List<TypeElement> findTypes(TypeElement typeElement) {
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
        for (AnnotationMirror annotationMirror : PropertyEditorProcessor.findAnnotationMirrors((TypeElement)typeElement, (String)this.getAnnotationClass().getName())) {
            for (AnnotationValue annotationValue : this.findCollectionValueMember(annotationMirror, "value")) {
                arrayList.add(PropertyEditorProcessor.toElement((AnnotationValue)annotationValue));
            }
        }
        return arrayList;
    }

    private void register(String string, TypeElement typeElement) {
        this.data.getPropertyEditor(string, this.createProperQualifiedName(typeElement));
    }
}

