/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.compile.core.processor.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.kordamp.jipsy.processor.LogLocation;
import org.kordamp.jipsy.processor.Logger;

public final class Type {
    private final Logger logger;
    private final String typeName;
    private final Set<String> providers = new LinkedHashSet<String>();

    public Type(Logger logger, String string) {
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.logger = logger;
        logger.note(LogLocation.LOG_FILE, "Creating " + string);
        this.typeName = string;
    }

    public void addProvider(String string) {
        if (string == null) {
            throw new NullPointerException("provider");
        }
        this.logger.note(LogLocation.LOG_FILE, "Adding " + string + " to " + this.typeName);
        this.providers.add(string);
    }

    public boolean contains(String string) {
        return this.providers.contains(string);
    }

    public boolean removeProvider(String string) {
        if (this.providers.remove(string)) {
            this.logger.note(LogLocation.LOG_FILE, "Removing " + string + " from " + this.typeName);
            return true;
        }
        return false;
    }

    public String getName() {
        return this.typeName;
    }

    public String toProviderNamesList() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>(this.providers);
        Collections.sort(arrayList);
        for (String string : arrayList) {
            stringBuilder.append(string).append("\n");
        }
        return stringBuilder.toString();
    }

    public void fromProviderNamesList(String string) {
        String[] stringArray;
        if (string == null) {
            throw new NullPointerException("input");
        }
        for (String string2 : stringArray = string.split("\\n")) {
            String string3;
            String[] stringArray2 = string2.split("#");
            if (stringArray2.length <= 0 || (string3 = stringArray2[0].trim()).length() <= 0) continue;
            this.addProvider(string3);
        }
    }

    public String toString() {
        return this.typeName + "=" + this.providers;
    }
}

