/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.compile.core.processor.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.griffon.compile.core.processor.type.Type;
import org.kordamp.jipsy.processor.Initializer;
import org.kordamp.jipsy.processor.LogLocation;
import org.kordamp.jipsy.processor.Logger;

public final class TypeCollector {
    private final Map<String, Type> types = new LinkedHashMap<String, Type>();
    private final Map<String, Type> cached = new LinkedHashMap<String, Type>();
    private final List<String> removed = new ArrayList<String>();
    private final Initializer initializer;
    private final Logger logger;

    public TypeCollector(Initializer initializer, Logger logger) {
        this.initializer = initializer;
        this.logger = logger;
    }

    public void cache() {
        this.cached.putAll(this.types);
    }

    public boolean isModified() {
        if (this.cached.size() != this.types.size()) {
            return true;
        }
        for (Map.Entry<String, Type> entry : this.cached.entrySet()) {
            if (!this.types.containsKey(entry.getKey())) {
                return true;
            }
            if (entry.getValue().equals(this.types.get(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    public Type getType(String string) {
        if (string == null) {
            throw new NullPointerException("type");
        }
        if (!this.types.containsKey(string)) {
            Type type = new Type(this.logger, string);
            CharSequence charSequence = this.initializer.initialData(string);
            if (charSequence != null) {
                type.fromProviderNamesList(charSequence.toString());
                for (String string2 : this.removed) {
                    type.removeProvider(string2);
                }
            }
            this.types.put(string, type);
        }
        return this.types.get(string);
    }

    public Collection<Type> types() {
        return Collections.unmodifiableMap(this.types).values();
    }

    public void removeProvider(String string) {
        if (string == null) {
            throw new NullPointerException("provider");
        }
        this.logger.note(LogLocation.LOG_FILE, "Removing " + string);
        this.removed.add(string);
        for (Type type : this.types.values()) {
            type.removeProvider(string);
        }
    }

    public String toString() {
        return this.types.values().toString();
    }
}

