/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.compile.core.processor.type;

import griffon.metadata.TypeProviderFor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.codehaus.griffon.compile.core.processor.type.Type;
import org.codehaus.griffon.compile.core.processor.type.TypeCollector;
import org.codehaus.griffon.compile.core.processor.type.TypePersistence;
import org.kordamp.jipsy.processor.AbstractSpiProcessor;
import org.kordamp.jipsy.processor.CheckResult;
import org.kordamp.jipsy.processor.LogLocation;
import org.kordamp.jipsy.processor.Persistence;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"spi_dir", "spi_log", "spi_verbose", "spi_disabled"})
public class TypeProviderProcessor
extends AbstractSpiProcessor {
    public static final String NAME = TypeProviderProcessor.class.getName() + " (" + TypeProviderProcessor.class.getPackage().getImplementationVersion() + ")";
    private static final int MAX_SUPPORTED_VERSION = 8;
    private Persistence persistence;
    private TypeCollector data;

    protected Class<? extends Annotation> getAnnotationClass() {
        return TypeProviderFor.class;
    }

    public SourceVersion getSupportedSourceVersion() {
        SourceVersion[] sourceVersionArray = SourceVersion.values();
        for (int i = sourceVersionArray.length - 1; i >= 0; --i) {
            int n;
            String string = sourceVersionArray[i].name();
            Matcher matcher = RELEASE_PATTERN.matcher(string);
            if (!matcher.matches() || (n = Integer.parseInt(matcher.group(1))) > 8) continue;
            return sourceVersionArray[i];
        }
        return SourceVersion.RELEASE_6;
    }

    protected void initialize() {
        super.initialize();
        this.persistence = new TypePersistence(NAME, this.options.dir(), this.processingEnv.getFiler(), this.logger);
        this.data = new TypeCollector(this.persistence.getInitializer(), this.logger);
        for (String string : this.persistence.tryFind()) {
            this.data.getType(string);
        }
        this.data.cache();
    }

    protected void writeData() {
        if (this.data.isModified()) {
            if (this.data.types().isEmpty()) {
                this.logger.note(LogLocation.LOG_FILE, "Writing output");
                try {
                    this.persistence.delete();
                }
                catch (IOException iOException) {
                    this.logger.warning(LogLocation.LOG_FILE, "An error occurred while deleting data file");
                }
            } else {
                this.logger.note(LogLocation.LOG_FILE, "Writing output");
                for (Type type : this.data.types()) {
                    try {
                        this.persistence.write(type.getName(), type.toProviderNamesList());
                    }
                    catch (IOException iOException) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, iOException.getMessage());
                    }
                }
                this.persistence.writeLog();
            }
        }
    }

    protected void removeStaleData(RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getRootElements()) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            this.data.removeProvider(this.createProperQualifiedName(typeElement));
        }
    }

    protected void handleElement(Element element) {
        if (!(element instanceof TypeElement)) {
            return;
        }
        TypeElement typeElement = (TypeElement)element;
        CheckResult checkResult = this.checkCurrentClass(typeElement);
        if (checkResult.isError()) {
            this.reportError(typeElement, checkResult);
            return;
        }
        for (TypeElement typeElement2 : this.findTypes(typeElement)) {
            CheckResult checkResult2 = this.isImplementation(typeElement, typeElement2);
            if (checkResult2.isError()) {
                this.reportError(typeElement, checkResult2);
                continue;
            }
            this.register(this.createProperQualifiedName(typeElement2), typeElement);
        }
    }

    private CheckResult checkCurrentClass(TypeElement typeElement) {
        if (typeElement.getKind() != ElementKind.CLASS || typeElement.getKind() != ElementKind.INTERFACE) {
            return CheckResult.valueOf((String)"is not a class nor an interface");
        }
        if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return CheckResult.valueOf((String)"is not public");
        }
        return CheckResult.OK;
    }

    private List<TypeElement> findTypes(TypeElement typeElement) {
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
        for (AnnotationMirror annotationMirror : TypeProviderProcessor.findAnnotationMirrors((TypeElement)typeElement, (String)this.getAnnotationClass().getName())) {
            arrayList.add(TypeProviderProcessor.toElement((AnnotationValue)this.findSingleValueMember(annotationMirror, "value")));
        }
        return arrayList;
    }

    private void register(String string, TypeElement typeElement) {
        this.data.getType(string).addProvider(this.createProperQualifiedName(typeElement));
    }
}

