/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.preferences.persistors;

import griffon.core.GriffonApplication;
import griffon.plugins.preferences.Preferences;
import griffon.plugins.preferences.PreferencesManager;
import griffon.plugins.preferences.PreferencesNode;
import griffon.plugins.preferences.persistors.AbstractMapBasedPreferencesPersistor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonPreferencesPersistor
extends AbstractMapBasedPreferencesPersistor {
    @Inject
    public JsonPreferencesPersistor(@Nonnull GriffonApplication application) {
        super(application);
    }

    @Nonnull
    protected String resolvePrefix() {
        return ".json";
    }

    @Nonnull
    public Preferences read(@Nonnull PreferencesManager preferencesManager) throws IOException {
        JSONObject json = this.doRead(this.inputStream());
        PreferencesNode node = preferencesManager.getPreferences().getRoot();
        this.readInto(json, node);
        return preferencesManager.getPreferences();
    }

    private void readInto(@Nonnull JSONObject json, @Nonnull PreferencesNode node) {
        for (Object k : json.keySet()) {
            String key = String.valueOf(k);
            Object value = json.get(key);
            if (value instanceof JSONObject) {
                this.readInto((JSONObject)value, node.node(key));
                continue;
            }
            if (value instanceof JSONArray) {
                try {
                    node.putAt(key, (Object)this.expand((JSONArray)value));
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Invalid value for '" + node.path() + "." + key + "' => " + value, iae);
                }
            }
            if (value instanceof Number || value instanceof Boolean || value instanceof CharSequence) {
                node.putAt(key, value);
                continue;
            }
            throw new IllegalArgumentException("Invalid value for '" + node.path() + "." + key + "' => " + value);
        }
    }

    @Nonnull
    private Collection expand(@Nonnull JSONArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            Object element = array.get(i);
            if (!(element instanceof Number || element instanceof Boolean || element instanceof CharSequence)) {
                throw new IllegalArgumentException("Invalid value: " + element);
            }
            list.add(element);
        }
        return list;
    }

    @Nonnull
    private JSONObject doRead(@Nonnull InputStream inputStream) throws IOException {
        if (inputStream.available() > 0) {
            return new JSONObject(new JSONTokener(inputStream));
        }
        return new JSONObject();
    }

    protected void write(@Nonnull Map<String, Object> map, @Nonnull OutputStream outputStream) throws IOException {
        JSONObject json = new JSONObject(map);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        writer.write(json.toString(4));
        writer.flush();
    }
}

