/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.glazedlists.gui;

import ca.odell.glazedlists.gui.AdvancedTableFormat;
import griffon.plugins.glazedlists.ColumnReader;
import griffon.plugins.glazedlists.gui.DefaultTableFormat;
import griffon.util.GriffonClassUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DefaultAdvancedTableFormat<E>
extends DefaultTableFormat<E>
implements AdvancedTableFormat<E> {
    private static final Class DEFAULT_CLASS = Object.class;
    private static final Comparator<Object> DEFAULT_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            return -1;
        }
    };
    private static final String CLASS = "class";
    private static final String COMPARATOR = "comparator";
    private final Class[] columnClasses;
    private final Comparator[] columnComparators;

    public DefaultAdvancedTableFormat(@Nonnull String[] columnNames) {
        super(columnNames);
        this.columnClasses = new Class[columnNames.length];
        this.columnComparators = new Comparator[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            this.columnClasses[i] = DEFAULT_CLASS;
            this.columnComparators[i] = DEFAULT_COMPARATOR;
        }
    }

    public DefaultAdvancedTableFormat(@Nonnull String[] columnNames, @Nonnull String[] columnTitles, @Nonnull ColumnReader[] columnReaders, @Nonnull Class[] columnClasses, @Nonnull Comparator[] columnComparators) {
        super(columnNames, columnTitles, columnReaders);
        this.columnClasses = Objects.requireNonNull(columnClasses, "Argument 'columnClasses' must not be null.");
        this.columnComparators = Objects.requireNonNull(columnComparators, "Argument 'columnComparators' must not be null.");
        GriffonClassUtils.requireState((columnNames.length == columnClasses.length ? 1 : 0) != 0, (String)("Arguments 'columNames' and 'columnClasses' have different cardinality. " + columnNames.length + " != " + columnClasses.length));
        GriffonClassUtils.requireState((columnNames.length == columnComparators.length ? 1 : 0) != 0, (String)("Arguments 'columNames' and 'columnComparators' have different cardinality. " + columnNames.length + " != " + columnComparators.length));
    }

    public DefaultAdvancedTableFormat(@Nonnull List<Map<String, Object>> options) {
        super(options);
        this.columnClasses = new Class[this.columnNames.length];
        this.columnComparators = new Comparator[this.columnNames.length];
        int i = 0;
        for (Map<String, Object> op : options) {
            this.columnClasses[i] = op.containsKey(CLASS) && op.get(CLASS) instanceof Class ? (Class)op.get(CLASS) : DEFAULT_CLASS;
            this.columnComparators[i] = op.containsKey(COMPARATOR) && op.get(COMPARATOR) instanceof Comparator ? (Comparator)op.get(COMPARATOR) : DEFAULT_COMPARATOR;
            ++i;
        }
    }

    public Class getColumnClass(int column) {
        return this.columnClasses[column];
    }

    public Comparator getColumnComparator(int column) {
        return this.columnComparators[column];
    }
}

