/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.glazedlists.gui;

import ca.odell.glazedlists.gui.TableFormat;
import griffon.plugins.glazedlists.ColumnReader;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DefaultTableFormat<E>
implements TableFormat<E> {
    private static final String ERROR_COLUMN_NAMES_NULL = "Argument 'columnNames' must not be null.";
    protected final String[] columnNames;
    protected final String[] columnTitles;
    protected final ColumnReader[] columnReaders;
    private static final String NAME = "name";
    private static final String TITLE = "title";
    private static final String READER = "reader";

    public DefaultTableFormat(@Nonnull String[] columnNames) {
        this.columnNames = Objects.requireNonNull(columnNames, ERROR_COLUMN_NAMES_NULL);
        this.columnTitles = new String[columnNames.length];
        this.columnReaders = new ColumnReader[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            this.columnTitles[i] = GriffonNameUtils.getNaturalName((String)columnNames[i]);
            this.columnReaders[i] = ColumnReader.DEFAULT;
        }
    }

    public DefaultTableFormat(@Nonnull String[] columnNames, @Nonnull String[] columnTitles, @Nonnull ColumnReader[] columnReaders) {
        this.columnNames = Objects.requireNonNull(columnNames, ERROR_COLUMN_NAMES_NULL);
        this.columnTitles = Objects.requireNonNull(columnTitles, "Argument 'columnTitles' must not be null.");
        this.columnReaders = Objects.requireNonNull(columnReaders, "Argument 'columnReaders' must not be null.");
        GriffonClassUtils.requireState((columnNames.length == columnTitles.length ? 1 : 0) != 0, (String)("Arguments 'columNames' and 'columnTitles' have different cardinality. " + columnNames.length + " != " + columnTitles.length));
        GriffonClassUtils.requireState((columnNames.length == columnReaders.length ? 1 : 0) != 0, (String)("Arguments 'columNames' and 'columnReaders' have different cardinality. " + columnNames.length + " != " + columnReaders.length));
    }

    public DefaultTableFormat(@Nonnull List<Map<String, Object>> options) {
        Objects.requireNonNull(options, "Argument 'options' must not be null.");
        GriffonClassUtils.requireState((options.size() > 0 ? 1 : 0) != 0, (String)"Argument 'options' must have at least one entry.");
        this.columnNames = new String[options.size()];
        this.columnTitles = new String[options.size()];
        this.columnReaders = new ColumnReader[options.size()];
        int i = 0;
        for (Map<String, Object> op : options) {
            if (op.containsKey(NAME)) {
                this.columnNames[i] = String.valueOf(op.get(NAME));
            }
            if (GriffonNameUtils.isBlank((String)this.columnNames[i])) {
                throw new IllegalArgumentException("Column " + i + " must have a value for name:");
            }
            this.columnTitles[i] = op.containsKey(TITLE) ? String.valueOf(op.get(TITLE)) : GriffonNameUtils.getNaturalName((String)this.columnNames[i]);
            this.columnReaders[i] = op.containsKey(READER) && op.get(READER) instanceof ColumnReader ? (ColumnReader)op.get(READER) : ColumnReader.DEFAULT;
            ++i;
        }
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int column) {
        return this.columnTitles[column];
    }

    public Object getColumnValue(E baseObject, int column) {
        return this.columnReaders[column].getValue(baseObject, this.columnNames[column], column);
    }
}

