/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.glazedlists.gui;

import ca.odell.glazedlists.gui.WritableTableFormat;
import griffon.plugins.glazedlists.ColumnEdit;
import griffon.plugins.glazedlists.ColumnWriter;
import griffon.plugins.glazedlists.gui.DefaultAdvancedTableFormat;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class DefaultWritableTableFormat<E>
extends DefaultAdvancedTableFormat<E>
implements WritableTableFormat<E> {
    protected final ColumnWriter[] columnWriters;
    protected final ColumnEdit[] columnEdits;
    private static final String WRITER = "writer";
    private static final String EDITABLE = "editable";

    public DefaultWritableTableFormat(@Nonnull List<Map<String, Object>> options) {
        super(options);
        this.columnWriters = new ColumnWriter[options.size()];
        this.columnEdits = new ColumnEdit[options.size()];
        int i = 0;
        for (Map<String, Object> op : options) {
            this.columnWriters[i] = op.containsKey(WRITER) && op.get(WRITER) instanceof ColumnWriter ? (ColumnWriter)op.get(WRITER) : ColumnWriter.DEFAULT;
            this.columnEdits[i] = op.containsKey(EDITABLE) && op.get(EDITABLE) instanceof ColumnEdit ? (ColumnEdit)op.get(EDITABLE) : ColumnEdit.DEFAULT;
            ++i;
        }
    }

    public boolean isEditable(E baseObject, int column) {
        return this.columnEdits[column].isEditable(baseObject, this.columnNames[column], column);
    }

    public E setColumnValue(E baseObject, Object editedValue, int column) {
        this.columnWriters[column].setValue(baseObject, this.columnNames[column], column, editedValue);
        return baseObject;
    }
}

