/*
 * Decompiled with CFR 0.152.
 */
package griffon.core;

import griffon.core.ApplicationEvent;
import griffon.core.CallableWithArgs;
import griffon.core.ExceptionHandler;
import griffon.core.GriffonApplication;
import griffon.util.GriffonNameUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GriffonExceptionHandler
implements ExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GriffonExceptionHandler.class);
    private static final String[] CONFIG_OPTIONS = new String[]{"griffon.full.stacktrace", "griffon.exception.output"};
    private static final String[] GRIFFON_PACKAGES = System.getProperty("griffon.sanitized.stacktraces", "org.codehaus.groovy.,org.codehaus.griffon.,groovy.,java.,javax.,sun.,com.sun.,").split("(\\s|,)+");
    private static final List<CallableWithArgs<Boolean>> TESTS = new ArrayList<CallableWithArgs<Boolean>>();
    private GriffonApplication application;

    public static void addClassTest(CallableWithArgs<Boolean> callableWithArgs) {
        TESTS.add(callableWithArgs);
    }

    public GriffonExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public GriffonExceptionHandler(GriffonApplication griffonApplication) {
        this.application = griffonApplication;
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Nullable
    protected GriffonApplication getApplication() {
        return this.application;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        this.handle(throwable);
    }

    @Override
    public void handle(Throwable throwable) {
        try {
            GriffonExceptionHandler.sanitize(throwable);
            if (GriffonExceptionHandler.isOutputEnabled()) {
                throwable.printStackTrace(System.err);
            }
            LOG.error("Uncaught Exception", throwable);
            if (this.application != null) {
                this.application.getEventRouter().publishEvent("Uncaught" + GriffonNameUtils.getShortName(throwable.getClass()), Arrays.asList(throwable));
                this.application.getEventRouter().publishEvent(ApplicationEvent.UNCAUGHT_EXCEPTION_THROWN.getName(), Arrays.asList(throwable));
            }
        }
        catch (Throwable throwable2) {
            GriffonExceptionHandler.sanitize(throwable2);
            if (GriffonExceptionHandler.isOutputEnabled()) {
                throwable2.printStackTrace(System.err);
            }
            LOG.error("An error occurred while handling uncaught exception " + throwable, throwable2);
        }
    }

    public static Throwable sanitize(Throwable throwable) {
        try {
            if (!Boolean.getBoolean("griffon.full.stacktrace")) {
                GriffonExceptionHandler.deepSanitize(throwable);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        return throwable;
    }

    public static StackTraceElement[] sanitize(StackTraceElement[] stackTraceElementArray) {
        try {
            if (!Boolean.getBoolean("griffon.full.stacktrace")) {
                Throwable throwable = new Throwable();
                throwable.setStackTrace(stackTraceElementArray);
                GriffonExceptionHandler.sanitize(throwable);
                stackTraceElementArray = throwable.getStackTrace();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stackTraceElementArray;
    }

    public static boolean isOutputEnabled() {
        return Boolean.getBoolean("griffon.exception.output");
    }

    public static void configure(Map<String, Object> map) {
        for (String string : CONFIG_OPTIONS) {
            if (!map.containsKey(string)) continue;
            System.setProperty(string, String.valueOf(map.get(string)));
        }
    }

    public static void registerExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new GriffonExceptionHandler());
        System.setProperty("sun.awt.exception.handler", GriffonExceptionHandler.class.getName());
    }

    public static void handleThrowable(Throwable throwable) {
        Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), throwable);
    }

    public static Throwable deepSanitize(Throwable throwable) {
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = GriffonExceptionHandler.doSanitize(throwable2.getCause());
        }
        return GriffonExceptionHandler.doSanitize(throwable);
    }

    private static Throwable doSanitize(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if (!GriffonExceptionHandler.isApplicationClass(stackTraceElement.getClassName())) continue;
            arrayList.add(stackTraceElement);
        }
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[arrayList.size()];
        arrayList.toArray(stackTraceElementArray2);
        throwable.setStackTrace(stackTraceElementArray2);
        return throwable;
    }

    private static boolean isApplicationClass(String string) {
        for (CallableWithArgs<Boolean> callableWithArgs : TESTS) {
            if (!callableWithArgs.call(string).booleanValue()) continue;
            return false;
        }
        for (String string2 : GRIFFON_PACKAGES) {
            if (!string.startsWith(string2)) continue;
            return false;
        }
        return true;
    }
}

