/*
 * Decompiled with CFR 0.152.
 */
package griffon.core;

import griffon.core.Context;
import griffon.util.GriffonNameUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ObservableContext
extends Context {
    public void addContextEventListener(@Nonnull ContextEventListener var1);

    public void removeContextEventListener(@Nonnull ContextEventListener var1);

    @Nonnull
    public ContextEventListener[] getContextEventListeners();

    public static class ContextEvent {
        private final Type type;
        private final String key;
        private final Object oldValue;
        private final Object newValue;

        public ContextEvent(@Nonnull Type type, @Nonnull String string, @Nullable Object object, @Nullable Object object2) {
            this.type = Objects.requireNonNull(type, "Argument 'type' must not be null");
            this.key = GriffonNameUtils.requireNonBlank(string, "Argument 'key' must not be null");
            this.oldValue = object;
            this.newValue = object2;
        }

        @Nonnull
        public Type getType() {
            return this.type;
        }

        @Nonnull
        public String getKey() {
            return this.key;
        }

        @Nullable
        public Object getOldValue() {
            return this.oldValue;
        }

        @Nullable
        public Object getNewValue() {
            return this.newValue;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ContextEvent contextEvent = (ContextEvent)object;
            if (!this.key.equals(contextEvent.key)) {
                return false;
            }
            if (this.newValue != null ? !this.newValue.equals(contextEvent.newValue) : contextEvent.newValue != null) {
                return false;
            }
            if (this.oldValue != null ? !this.oldValue.equals(contextEvent.oldValue) : contextEvent.oldValue != null) {
                return false;
            }
            return this.type == contextEvent.type;
        }

        public int hashCode() {
            int n = this.type.hashCode();
            n = 31 * n + this.key.hashCode();
            n = 31 * n + (this.oldValue != null ? this.oldValue.hashCode() : 0);
            n = 31 * n + (this.newValue != null ? this.newValue.hashCode() : 0);
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("ContextEvent{");
            stringBuilder.append("type=").append((Object)this.type);
            stringBuilder.append(", key='").append(this.key).append('\'');
            stringBuilder.append(", oldValue=").append(this.oldValue);
            stringBuilder.append(", newValue=").append(this.newValue);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        public static enum Type {
            ADD,
            REMOVE,
            UPDATE;

        }
    }

    public static interface ContextEventListener {
        public void contextChanged(@Nonnull ContextEvent var1);
    }
}

