/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.GriffonExceptionHandler;
import griffon.core.editors.ExtendedPropertyEditor;
import griffon.core.editors.ValueConversionException;
import griffon.core.formatters.Formatter;
import griffon.core.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import java.beans.PropertyEditorSupport;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertyEditor
extends PropertyEditorSupport
implements ExtendedPropertyEditor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPropertyEditor.class);
    private String format;

    @Override
    @Nullable
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(@Nullable String string) {
        this.format = string;
    }

    @Override
    public String getAsText() {
        return GriffonNameUtils.isBlank(this.getFormat()) ? this.getAsTextInternal() : this.getFormattedValue();
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if (GriffonNameUtils.isBlank(this.getFormat())) {
            this.setAsTextInternal(string);
        } else {
            this.setFormattedValue(string);
        }
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof CharSequence) {
            this.setFormattedValue(String.valueOf(object));
        } else {
            this.setValueInternal(object);
        }
    }

    protected void setValueInternal(Object object) {
        super.setValue(object);
    }

    protected Object getValueInternal() {
        return super.getValue();
    }

    protected void setAsTextInternal(String string) throws IllegalArgumentException {
        this.setValueInternal(string);
    }

    protected String getAsTextInternal() {
        return super.getAsText();
    }

    @Override
    public String getFormattedValue() {
        Object object = this.getValueInternal();
        Formatter<?> formatter = this.resolveFormatter();
        if (formatter != null) {
            return formatter.format(object);
        }
        return object != null ? object.toString() : null;
    }

    @Override
    public void setFormattedValue(String string) {
        Formatter<?> formatter = this.resolveFormatter();
        if (formatter != null) {
            try {
                this.setValueInternal(formatter.parse(string));
            }
            catch (ParseException parseException) {
                ParseException parseException2 = (ParseException)GriffonExceptionHandler.sanitize(parseException);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Cannot parse value " + string, (Throwable)parseException2);
                }
                throw new ValueConversionException((Object)string, parseException2);
            }
        } else {
            this.setValueInternal(string);
        }
    }

    protected Formatter<?> resolveFormatter() {
        return null;
    }

    protected ValueConversionException illegalValue(Object object, Class<?> clazz) {
        throw new ValueConversionException(object, clazz);
    }

    protected ValueConversionException illegalValue(Object object, Class<?> clazz, Exception exception) {
        throw new ValueConversionException(object, clazz, exception);
    }
}

