/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.core.formatters.BigDecimalFormatter;
import griffon.core.formatters.Formatter;
import griffon.util.GriffonNameUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigDecimalPropertyEditor
extends AbstractPropertyEditor {
    @Override
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof Number) {
            this.handleAsNumber((Number)object);
        } else {
            throw this.illegalValue(object, BigDecimal.class);
        }
    }

    protected void handleAsString(String string) {
        try {
            super.setValueInternal(GriffonNameUtils.isBlank(string) ? null : new BigDecimal(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, BigDecimal.class, numberFormatException);
        }
    }

    protected void handleAsNumber(Number number) {
        if (number instanceof BigInteger) {
            super.setValueInternal(new BigDecimal((BigInteger)number));
        } else if (number instanceof BigDecimal) {
            super.setValueInternal(number);
        } else {
            super.setValueInternal(number.longValue());
        }
    }

    protected Formatter<BigDecimal> resolveFormatter() {
        return GriffonNameUtils.isBlank(this.getFormat()) ? null : new BigDecimalFormatter(this.getFormat());
    }
}

