/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.core.formatters.BigIntegerFormatter;
import griffon.core.formatters.Formatter;
import griffon.util.GriffonNameUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigIntegerPropertyEditor
extends AbstractPropertyEditor {
    @Override
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof Number) {
            this.handleAsNumber((Number)object);
        } else {
            throw this.illegalValue(object, BigInteger.class);
        }
    }

    protected void handleAsString(String string) {
        try {
            super.setValueInternal(GriffonNameUtils.isBlank(string) ? null : new BigInteger(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, BigInteger.class, numberFormatException);
        }
    }

    protected void handleAsNumber(Number number) {
        if (number instanceof BigDecimal) {
            super.setValueInternal(((BigDecimal)number).toBigInteger());
        } else if (number instanceof BigInteger) {
            super.setValueInternal(number);
        } else {
            super.setValueInternal(number.longValue());
        }
    }

    protected Formatter<BigInteger> resolveFormatter() {
        return GriffonNameUtils.isBlank(this.getFormat()) ? null : new BigIntegerFormatter(this.getFormat());
    }
}

