/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.core.formatters.BooleanFormatter;
import griffon.core.formatters.Formatter;
import griffon.util.GriffonNameUtils;

public class BooleanPropertyEditor
extends AbstractPropertyEditor {
    @Override
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof Boolean) {
            this.handleAsBoolean((Boolean)object);
        } else {
            throw this.illegalValue(object, Boolean.class);
        }
    }

    protected void handleAsString(String string) {
        super.setValueInternal(GriffonNameUtils.isBlank(string) ? null : Boolean.valueOf(Boolean.parseBoolean(string)));
    }

    protected void handleAsBoolean(Boolean bl) {
        super.setValueInternal(bl);
    }

    protected Formatter<Boolean> resolveFormatter() {
        return GriffonNameUtils.isBlank(this.getFormat()) ? null : BooleanFormatter.getInstance(this.getFormat());
    }
}

