/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.core.formatters.ByteFormatter;
import griffon.core.formatters.Formatter;
import griffon.util.GriffonNameUtils;

public class BytePropertyEditor
extends AbstractPropertyEditor {
    @Override
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof Number) {
            this.handleAsNumber((Number)object);
        } else {
            throw this.illegalValue(object, Byte.class);
        }
    }

    protected void handleAsString(String string) {
        try {
            super.setValueInternal(GriffonNameUtils.isBlank(string) ? null : Byte.valueOf(Byte.parseByte(string)));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, Byte.class, numberFormatException);
        }
    }

    protected void handleAsNumber(Number number) {
        super.setValueInternal(number.byteValue());
    }

    protected Formatter<Byte> resolveFormatter() {
        return GriffonNameUtils.isBlank(this.getFormat()) ? null : new ByteFormatter(this.getFormat());
    }
}

