/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.core.formatters.CalendarFormatter;
import griffon.core.formatters.Formatter;
import griffon.util.GriffonNameUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CalendarPropertyEditor
extends AbstractPropertyEditor {
    @Override
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof Calendar) {
            super.setValueInternal(object);
        } else if (object instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            super.setValueInternal(calendar);
        } else if (object instanceof Number) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(((Number)object).longValue()));
            super.setValueInternal(calendar);
        } else {
            throw this.illegalValue(object, Calendar.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank(string)) {
            super.setValueInternal(null);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(new Date(Long.parseLong(string)));
            super.setValueInternal(calendar);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                calendar.setTime(new SimpleDateFormat().parse(string));
                super.setValueInternal(calendar);
            }
            catch (ParseException parseException) {
                throw this.illegalValue(string, Calendar.class, parseException);
            }
            return;
        }
    }

    protected Formatter<Calendar> resolveFormatter() {
        return GriffonNameUtils.isBlank(this.getFormat()) ? null : new CalendarFormatter(this.getFormat());
    }
}

