/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.core.formatters.DateFormatter;
import griffon.core.formatters.Formatter;
import griffon.util.GriffonNameUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DatePropertyEditor
extends AbstractPropertyEditor {
    @Override
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof Date) {
            super.setValueInternal(object);
        } else if (object instanceof Calendar) {
            super.setValueInternal(((Calendar)object).getTime());
        } else if (object instanceof Number) {
            super.setValueInternal(new Date(((Number)object).longValue()));
        } else {
            throw this.illegalValue(object, Date.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank(string)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal(new Date(Long.parseLong(string)));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                super.setValueInternal(new SimpleDateFormat().parse(string));
            }
            catch (ParseException parseException) {
                throw this.illegalValue(string, Date.class, parseException);
            }
            return;
        }
    }

    protected Formatter<Date> resolveFormatter() {
        return GriffonNameUtils.isBlank(this.getFormat()) ? null : new DateFormatter(this.getFormat());
    }
}

