/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.core.formatters.DoubleFormatter;
import griffon.core.formatters.Formatter;
import griffon.util.GriffonNameUtils;

public class DoublePropertyEditor
extends AbstractPropertyEditor {
    @Override
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof Number) {
            this.handleAsNumber((Number)object);
        } else {
            throw this.illegalValue(object, Double.class);
        }
    }

    protected void handleAsString(String string) {
        try {
            super.setValueInternal(GriffonNameUtils.isBlank(string) ? null : Double.valueOf(Double.parseDouble(string)));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, Double.class, numberFormatException);
        }
    }

    protected void handleAsNumber(Number number) {
        super.setValueInternal(number.doubleValue());
    }

    protected Formatter<Double> resolveFormatter() {
        return GriffonNameUtils.isBlank(this.getFormat()) ? null : new DoubleFormatter(this.getFormat());
    }
}

