/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.core.formatters.FloatFormatter;
import griffon.core.formatters.Formatter;
import griffon.util.GriffonNameUtils;

public class FloatPropertyEditor
extends AbstractPropertyEditor {
    @Override
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof Number) {
            this.handleAsNumber((Number)object);
        } else {
            throw this.illegalValue(object, Float.class);
        }
    }

    protected void handleAsString(String string) {
        try {
            super.setValueInternal(GriffonNameUtils.isBlank(string) ? null : Float.valueOf(Float.parseFloat(string)));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, Float.class, numberFormatException);
        }
    }

    protected void handleAsNumber(Number number) {
        super.setValueInternal(Float.valueOf(number.floatValue()));
    }

    protected Formatter<Float> resolveFormatter() {
        return GriffonNameUtils.isBlank(this.getFormat()) ? null : new FloatFormatter(this.getFormat());
    }
}

