/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.core.formatters.Formatter;
import griffon.core.formatters.IntegerFormatter;
import griffon.util.GriffonNameUtils;

public class IntegerPropertyEditor
extends AbstractPropertyEditor {
    @Override
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof Number) {
            this.handleAsNumber((Number)object);
        } else {
            throw this.illegalValue(object, Integer.class);
        }
    }

    protected void handleAsString(String string) {
        try {
            super.setValueInternal(GriffonNameUtils.isBlank(string) ? null : Integer.valueOf(Integer.parseInt(string)));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, Integer.class, numberFormatException);
        }
    }

    protected void handleAsNumber(Number number) {
        super.setValueInternal(number.intValue());
    }

    protected Formatter<Integer> resolveFormatter() {
        return GriffonNameUtils.isBlank(this.getFormat()) ? null : new IntegerFormatter(this.getFormat());
    }
}

