/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.core.formatters.Formatter;
import griffon.core.formatters.LongFormatter;
import griffon.util.GriffonNameUtils;

public class LongPropertyEditor
extends AbstractPropertyEditor {
    @Override
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof Number) {
            this.handleAsNumber((Number)object);
        } else {
            throw this.illegalValue(object, Long.class);
        }
    }

    protected void handleAsString(String string) {
        try {
            super.setValueInternal(GriffonNameUtils.isBlank(string) ? null : Long.valueOf(Long.parseLong(string)));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, Long.class, numberFormatException);
        }
    }

    protected void handleAsNumber(Number number) {
        super.setValueInternal(number.longValue());
    }

    protected Formatter<Long> resolveFormatter() {
        return GriffonNameUtils.isBlank(this.getFormat()) ? null : new LongFormatter(this.getFormat());
    }
}

