/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.ExtendedPropertyEditor;
import griffon.core.editors.ValueConversionException;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class PropertyEditorChain
extends PropertyEditorSupport
implements ExtendedPropertyEditor {
    private final Class<?> targetClass;
    private final Object lock = new Object[0];
    private final WeakReference<Class<? extends PropertyEditor>>[] propertyEditorClasses;
    @GuardedBy(value="lock")
    private WeakReference<PropertyEditor>[] propertyEditors;
    private String format;

    public PropertyEditorChain(@Nonnull Class<?> clazz, @Nonnull Class<? extends PropertyEditor>[] classArray) {
        this.targetClass = Objects.requireNonNull(clazz, "Argument 'targetClass' must not be null");
        GriffonClassUtils.requireNonEmpty(classArray, "Argument 'propertyEditorClasses' must not be null nor empty");
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Collections.addAll(linkedHashSet, classArray);
        int n = 0;
        this.propertyEditorClasses = new WeakReference[linkedHashSet.size()];
        for (Class clazz2 : linkedHashSet) {
            this.propertyEditorClasses[n++] = new WeakReference<Class>(clazz2);
        }
    }

    @Override
    @Nullable
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(@Nullable String string) {
        this.format = string;
    }

    public int getSize() {
        return this.propertyEditorClasses.length;
    }

    public PropertyEditorChain copyOf() {
        ArrayList arrayList = new ArrayList();
        for (WeakReference<Class<? extends PropertyEditor>> weakReference : this.propertyEditorClasses) {
            if (weakReference.get() == null) continue;
            arrayList.add(weakReference.get());
        }
        return new PropertyEditorChain(this.targetClass, arrayList.toArray(new Class[arrayList.size()]));
    }

    public PropertyEditorChain copyOf(Class<? extends PropertyEditor> clazz) {
        Objects.requireNonNull(clazz, "Argument 'propertyEditorClass' must not be null");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (WeakReference<Class<? extends PropertyEditor>> weakReference : this.propertyEditorClasses) {
            if (weakReference.get() == null) continue;
            arrayList.add(weakReference.get());
        }
        if (!arrayList.contains(clazz)) {
            arrayList.add(clazz);
        }
        return new PropertyEditorChain(this.targetClass, arrayList.toArray(new Class[arrayList.size()]));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("[").append(this.targetClass.getName()).append(']');
        return stringBuilder.toString();
    }

    @Override
    public String getAsText() {
        return GriffonNameUtils.isBlank(this.getFormat()) ? this.getAsTextInternal() : this.getFormattedValue();
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if (GriffonNameUtils.isBlank(this.getFormat())) {
            this.setAsTextInternal(string);
        } else {
            this.setFormattedValue(string);
        }
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof CharSequence) {
            this.setFormattedValue(String.valueOf(object));
        } else {
            this.setValueInternal(object);
        }
    }

    @Override
    public String getFormattedValue() {
        this.initPropertyEditors();
        Object object = super.getValue();
        for (WeakReference<PropertyEditor> weakReference : this.propertyEditors) {
            try {
                PropertyEditor propertyEditor = (PropertyEditor)weakReference.get();
                if (propertyEditor == null || !(propertyEditor instanceof ExtendedPropertyEditor)) continue;
                ExtendedPropertyEditor extendedPropertyEditor = (ExtendedPropertyEditor)propertyEditor;
                extendedPropertyEditor.setFormat(this.format);
                extendedPropertyEditor.setValue(object);
                return extendedPropertyEditor.getFormattedValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw this.illegalValue(object, this.targetClass);
    }

    @Override
    public void setFormattedValue(String string) {
        this.initPropertyEditors();
        for (WeakReference<PropertyEditor> weakReference : this.propertyEditors) {
            try {
                PropertyEditor propertyEditor = (PropertyEditor)weakReference.get();
                if (propertyEditor == null || !(propertyEditor instanceof ExtendedPropertyEditor)) continue;
                ExtendedPropertyEditor extendedPropertyEditor = (ExtendedPropertyEditor)propertyEditor;
                extendedPropertyEditor.setFormat(this.format);
                extendedPropertyEditor.setValue(string);
                super.setValue(extendedPropertyEditor.getValue());
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw this.illegalValue(string, this.targetClass);
    }

    protected void setValueInternal(Object object) throws IllegalArgumentException {
        this.initPropertyEditors();
        for (WeakReference<PropertyEditor> weakReference : this.propertyEditors) {
            try {
                PropertyEditor propertyEditor = (PropertyEditor)weakReference.get();
                if (propertyEditor == null) continue;
                propertyEditor.setValue(object);
                super.setValue(propertyEditor.getValue());
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw this.illegalValue(object, this.targetClass);
    }

    protected Object getValueInternal() {
        this.initPropertyEditors();
        Object object = super.getValue();
        for (WeakReference<PropertyEditor> weakReference : this.propertyEditors) {
            try {
                PropertyEditor propertyEditor = (PropertyEditor)weakReference.get();
                if (propertyEditor == null) continue;
                propertyEditor.setValue(object);
                return propertyEditor.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw this.illegalValue(object, this.targetClass);
    }

    protected String getAsTextInternal() {
        this.initPropertyEditors();
        Object object = super.getValue();
        for (WeakReference<PropertyEditor> weakReference : this.propertyEditors) {
            try {
                PropertyEditor propertyEditor = (PropertyEditor)weakReference.get();
                if (propertyEditor == null) continue;
                propertyEditor.setValue(object);
                return propertyEditor.getAsText();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw this.illegalValue(object, this.targetClass);
    }

    protected void setAsTextInternal(String string) throws IllegalArgumentException {
        this.initPropertyEditors();
        for (WeakReference<PropertyEditor> weakReference : this.propertyEditors) {
            try {
                PropertyEditor propertyEditor = (PropertyEditor)weakReference.get();
                if (propertyEditor == null) continue;
                propertyEditor.setAsText(string);
                super.setValue(propertyEditor.getValue());
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw this.illegalValue(string, this.targetClass);
    }

    protected ValueConversionException illegalValue(Object object, Class<?> clazz) {
        throw new ValueConversionException(object, clazz);
    }

    protected ValueConversionException illegalValue(Object object, Class<?> clazz, Exception exception) {
        throw new ValueConversionException(object, clazz, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPropertyEditors() {
        Object object = this.lock;
        synchronized (object) {
            if (this.propertyEditors == null) {
                ArrayList arrayList = new ArrayList();
                for (WeakReference<Class<? extends PropertyEditor>> weakReference : this.propertyEditorClasses) {
                    try {
                        Class clazz = (Class)weakReference.get();
                        if (clazz == null) continue;
                        arrayList.add(new WeakReference(clazz.newInstance()));
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                        throw new IllegalArgumentException("Can't create instance", reflectiveOperationException);
                    }
                }
                if (arrayList.size() > 0) {
                    this.propertyEditors = arrayList.toArray(new WeakReference[arrayList.size()]);
                } else {
                    throw new IllegalStateException("No available PropertyEditors for " + this);
                }
            }
        }
    }
}

