/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.EnumPropertyEditor;
import griffon.core.editors.PropertyEditorChain;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyEditorResolver {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyEditorResolver.class);
    private static final Object LOCK = new Object[0];
    @GuardedBy(value="LOCK")
    private static final WeakCache<String, Class<? extends PropertyEditor>> propertyEditorRegistry = new WeakCache();
    @GuardedBy(value="LOCK")
    private static final Map<String, PropertyEditorChain> propertyEditorChainRegistry = new LinkedHashMap<String, PropertyEditorChain>();
    private static final String ERROR_TARGET_TYPE_NULL = "Argument 'targetType' must not be null";

    private PropertyEditorResolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Object object = LOCK;
        synchronized (object) {
            ((WeakCache)PropertyEditorResolver.propertyEditorRegistry).clear();
            propertyEditorChainRegistry.clear();
        }
    }

    @Nonnull
    public static PropertyEditor findEditor(@Nonnull Class<?> clazz) {
        PropertyEditor propertyEditor;
        Objects.requireNonNull(clazz, "Argument 'type' must not be  null");
        LOG.trace("Searching PropertyEditor for {}", (Object)clazz.getName());
        if (Enum.class.isAssignableFrom(clazz)) {
            propertyEditor = new EnumPropertyEditor();
            ((EnumPropertyEditor)propertyEditor).setEnumType(clazz);
        } else {
            propertyEditor = PropertyEditorResolver.doFindEditor(clazz);
        }
        if (propertyEditor == null) {
            propertyEditor = PropertyEditorManager.findEditor(clazz);
        }
        if (propertyEditor == null) {
            propertyEditor = new NoopPropertyEditor();
        }
        LOG.trace("PropertyEditor for {} is {}", (Object)clazz.getName(), (Object)propertyEditor.getClass().getName());
        return propertyEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterEditor(@Nonnull Class<?> clazz) {
        Objects.requireNonNull(clazz, ERROR_TARGET_TYPE_NULL);
        Object object = LOCK;
        synchronized (object) {
            String string = clazz.getName();
            propertyEditorChainRegistry.remove(string);
            ((WeakCache)PropertyEditorResolver.propertyEditorRegistry).remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerEditor(@Nonnull Class<?> clazz, @Nullable Class<? extends PropertyEditor> clazz2) {
        Objects.requireNonNull(clazz, ERROR_TARGET_TYPE_NULL);
        Object object = LOCK;
        synchronized (object) {
            String string = clazz.getName();
            if (clazz2 == null) {
                propertyEditorChainRegistry.remove(string);
                ((WeakCache)PropertyEditorResolver.propertyEditorRegistry).remove(string);
                return;
            }
            PropertyEditorChain propertyEditorChain = propertyEditorChainRegistry.get(string);
            if (propertyEditorChain != null) {
                PropertyEditorChain propertyEditorChain2 = propertyEditorChain.copyOf(clazz2);
                if (propertyEditorChain2.getSize() > 1) {
                    propertyEditorChainRegistry.put(string, propertyEditorChain2);
                } else {
                    propertyEditorChainRegistry.remove(string);
                    ((WeakCache)PropertyEditorResolver.propertyEditorRegistry).put(string, clazz2);
                }
            } else {
                Class clazz3 = (Class)((WeakCache)PropertyEditorResolver.propertyEditorRegistry).get(string);
                if (clazz3 != null) {
                    ((WeakCache)PropertyEditorResolver.propertyEditorRegistry).remove(string);
                    Class[] classArray = new Class[]{clazz3, clazz2};
                    PropertyEditorChain propertyEditorChain3 = new PropertyEditorChain(clazz, classArray);
                    if (propertyEditorChain3.getSize() > 1) {
                        propertyEditorChainRegistry.put(string, propertyEditorChain3);
                    } else {
                        propertyEditorChainRegistry.remove(string);
                        ((WeakCache)PropertyEditorResolver.propertyEditorRegistry).put(string, clazz2);
                    }
                } else {
                    propertyEditorChainRegistry.remove(string);
                    ((WeakCache)PropertyEditorResolver.propertyEditorRegistry).put(string, clazz2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyEditor doFindEditor(Class<?> clazz) {
        Object object = LOCK;
        synchronized (object) {
            String string = clazz.getName();
            if (propertyEditorChainRegistry.containsKey(string)) {
                PropertyEditorChain propertyEditorChain = propertyEditorChainRegistry.get(string);
                return propertyEditorChain.copyOf();
            }
            Class clazz2 = (Class)((WeakCache)PropertyEditorResolver.propertyEditorRegistry).get(string);
            if (clazz2 != null) {
                try {
                    return (PropertyEditor)clazz2.newInstance();
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    throw new IllegalStateException("Can't instantiate " + clazz2, reflectiveOperationException);
                }
            }
        }
        return null;
    }

    private static final class WeakCache<K, V> {
        private final Map<K, Reference<V>> map = new WeakHashMap<K, Reference<V>>();

        private WeakCache() {
        }

        private V get(K k) {
            Reference<V> reference = this.map.get(k);
            if (reference == null) {
                return null;
            }
            V v = reference.get();
            if (v == null) {
                this.map.remove(k);
            }
            return v;
        }

        private void put(K k, V v) {
            if (v != null) {
                this.map.put(k, new WeakReference<V>(v));
            } else {
                this.map.remove(k);
            }
        }

        private void remove(K k) {
            this.map.remove(k);
        }

        private boolean contains(K k) {
            Reference<V> reference = this.map.get(k);
            if (reference == null) {
                return false;
            }
            V v = reference.get();
            if (v == null) {
                this.map.remove(k);
                return false;
            }
            return true;
        }

        private void clear() {
            this.map.clear();
        }
    }

    public static final class NoopPropertyEditor
    extends PropertyEditorSupport {
    }
}

