/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class URIPropertyEditor
extends AbstractPropertyEditor {
    @Override
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof File) {
            this.handleAsFile((File)object);
        } else if (object instanceof URI) {
            super.setValueInternal(object);
        } else {
            throw this.illegalValue(object, URI.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank(string)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw this.illegalValue(string, URI.class, uRISyntaxException);
        }
    }

    protected void handleAsFile(File file) {
        super.setValueInternal(file.toURI());
    }
}

