/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class URLPropertyEditor
extends AbstractPropertyEditor {
    @Override
    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof File) {
            this.handleAsFile((File)object);
        } else if (object instanceof URL) {
            super.setValueInternal(object);
        } else {
            throw this.illegalValue(object, URL.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank(string)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw this.illegalValue(string, URL.class, malformedURLException);
        }
    }

    protected void handleAsFile(File file) {
        try {
            super.setValueInternal(file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw this.illegalValue(file, URL.class, malformedURLException);
        }
    }
}

