/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.env;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum Environment {
    DEVELOPMENT,
    PRODUCTION,
    TEST,
    CUSTOM;

    public static final String KEY = "griffon.env";
    private static final String PRODUCTION_ENV_SHORT_NAME = "prod";
    private static final String DEVELOPMENT_ENVIRONMENT_SHORT_NAME = "dev";
    private static final String TEST_ENVIRONMENT_SHORT_NAME = "test";
    private static final Map<String, String> ENV_NAME_MAPPINGS;
    private String name;

    public static boolean isSystemSet() {
        return System.getProperty(KEY) != null;
    }

    @Nullable
    public static Environment resolveEnvironment(@Nullable String string) {
        String string2 = ENV_NAME_MAPPINGS.get(string);
        if (string2 != null) {
            return Environment.valueOf(string2.toUpperCase());
        }
        return null;
    }

    @Nonnull
    public static String getEnvironmentShortName(@Nonnull Environment environment) {
        Objects.requireNonNull(environment, "Argument 'env' must not be null");
        switch (environment) {
            case DEVELOPMENT: {
                return DEVELOPMENT_ENVIRONMENT_SHORT_NAME;
            }
            case TEST: {
                return TEST_ENVIRONMENT_SHORT_NAME;
            }
            case PRODUCTION: {
                return PRODUCTION_ENV_SHORT_NAME;
            }
        }
        return environment.getName();
    }

    @Nonnull
    public String getName() {
        if (this != CUSTOM || this.name == null) {
            return this.toString().toLowerCase(Locale.getDefault());
        }
        return this.name;
    }

    public void setName(@Nullable String string) {
        this.name = string;
    }

    static {
        ENV_NAME_MAPPINGS = new LinkedHashMap<String, String>();
        ENV_NAME_MAPPINGS.put(DEVELOPMENT_ENVIRONMENT_SHORT_NAME, DEVELOPMENT.getName());
        ENV_NAME_MAPPINGS.put(PRODUCTION_ENV_SHORT_NAME, PRODUCTION.getName());
        ENV_NAME_MAPPINGS.put(TEST_ENVIRONMENT_SHORT_NAME, TEST.getName());
    }
}

