/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.env;

import griffon.util.GriffonNameUtils;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Feature {
    private static final String ERROR_FEATURE_NAME_BLANK = "Argument 'featureName' cannot be blank";

    public static boolean isFeatureEnabled(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_FEATURE_NAME_BLANK);
        return !GriffonNameUtils.isBlank(System.getProperty(string)) && Boolean.getBoolean(string);
    }

    public static void setFeatureEnabled(@Nonnull String string, boolean bl) {
        GriffonNameUtils.requireNonBlank(string, ERROR_FEATURE_NAME_BLANK);
        System.setProperty(string, String.valueOf(bl));
    }

    public static void withFeature(@Nonnull String string, @Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, "Argument 'runnable' cannot be null");
        if (Feature.isFeatureEnabled(string)) {
            runnable.run();
        }
    }
}

