/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.env;

import griffon.util.GriffonNameUtils;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GriffonEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(GriffonEnvironment.class);
    private static final String BUILD_DATE;
    private static final String BUILD_TIME;
    private static final String BUILD_REVISION;
    private static final String GRIFFON_VERSION;

    private GriffonEnvironment() {
    }

    public static String getGriffonVersion() {
        return GRIFFON_VERSION;
    }

    public static String getJvmVersion() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.getProperty("java.version")).append(" (").append(System.getProperty("java.vendor")).append(" ").append(System.getProperty("java.vm.version")).append(")");
        return stringBuilder.toString();
    }

    public static String getOsVersion() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append(" ").append(System.getProperty("os.arch"));
        return stringBuilder.toString();
    }

    public static String getBuildDateTime() {
        return BUILD_DATE + "T" + BUILD_TIME;
    }

    public static String getBuildDate() {
        return BUILD_DATE;
    }

    public static String getBuildTime() {
        return BUILD_TIME;
    }

    public static String getBuildRevision() {
        return BUILD_REVISION;
    }

    public static String prettyPrint() {
        GriffonEnvironment.padLeft("Griffon", 8, " ");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n------------------------------------------------------------\n").append(GriffonEnvironment.padLeft("Griffon", 9, " ")).append(" ").append(GriffonEnvironment.getGriffonVersion()).append("\n------------------------------------------------------------\n\n");
        GriffonEnvironment.entry("Build", GriffonEnvironment.getBuildDateTime(), stringBuilder);
        GriffonEnvironment.entry("Revision", GriffonEnvironment.getBuildRevision(), stringBuilder);
        GriffonEnvironment.entry("JVM", GriffonEnvironment.getJvmVersion(), stringBuilder);
        GriffonEnvironment.entry("OS", GriffonEnvironment.getOsVersion(), stringBuilder);
        return stringBuilder.toString();
    }

    private static void entry(String string, String string2, StringBuilder stringBuilder) {
        stringBuilder.append(GriffonEnvironment.padLeft(string, 8, " ")).append(": ").append(string2).append("\n");
    }

    private static String padLeft(String string, Number number, String string2) {
        int n = number.intValue();
        if (n <= string.length()) {
            return string;
        }
        return GriffonEnvironment.getPadding(string2, n - string.length()) + string;
    }

    private static String getPadding(String string, int n) {
        if (string.length() < n) {
            return GriffonEnvironment.multiply(string, n / string.length() + 1).substring(0, n);
        }
        return string.substring(0, n);
    }

    private static String multiply(String string, Number number) {
        int n = number.intValue();
        if (n == 0) {
            return "";
        }
        if (n < 0) {
            throw new IllegalArgumentException("multiply() should be called with a number of 0 or greater not: " + n);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    static {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            Properties properties = new Properties();
            URL uRL = GriffonEnvironment.class.getClassLoader().getResource("META-INF/griffon-core.properties");
            if (uRL != null) {
                properties.load(uRL.openStream());
                string = properties.getProperty("build.date");
                string2 = properties.getProperty("build.time");
                string3 = properties.getProperty("build.revision");
                string4 = properties.getProperty("griffon.version");
            }
            if (GriffonNameUtils.isBlank(string) || GriffonNameUtils.isBlank(string2) || GriffonNameUtils.isBlank(string4)) {
                LOG.error("Unable to read Griffon version from META-INF/griffon-core.properties. Are you sure the griffon-core jar is in the classpath?");
                string4 = "";
                string3 = "";
                string2 = "";
                string = "";
            }
        }
        catch (Exception exception) {
            LOG.error("Unable to read Griffon version from META-INF/griffon-core.properties. Are you sure the griffon-core jar is in the classpath? " + exception.getMessage(), (Throwable)exception);
            string4 = "";
            string3 = "";
            string2 = "";
            string = "";
        }
        BUILD_DATE = string;
        BUILD_TIME = string2;
        BUILD_REVISION = string3;
        GRIFFON_VERSION = string4;
    }
}

