/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.env;

import griffon.util.GriffonNameUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metadata {
    public static final String FILENAME = "application.properties";
    public static final String APPLICATION_VERSION = "application.version";
    public static final String APPLICATION_NAME = "application.name";
    private static final Logger LOG = LoggerFactory.getLogger(Metadata.class);
    private final Properties properties = new Properties();

    public Metadata(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, "Argument 'path' must not be blank");
        this.loadProperties(string);
    }

    public Metadata(@Nonnull File file) {
        Objects.requireNonNull(file, "Argument 'file' must not be null");
        this.loadProperties(file);
    }

    public Metadata(@Nonnull InputStream inputStream) {
        Objects.requireNonNull(inputStream, "Argument 'in' must not be null");
        try {
            this.loadProperties(inputStream);
        }
        catch (IOException iOException) {
            LOG.warn("Could not load application metadata from inpustream.", (Throwable)iOException);
        }
    }

    private void loadProperties(String string) {
        URL uRL = Metadata.class.getClassLoader().getResource(string);
        if (uRL != null) {
            try {
                this.loadProperties(uRL.openStream());
            }
            catch (IOException iOException) {
                LOG.warn("Could not load application metadata from " + string, (Throwable)iOException);
            }
        }
    }

    private void loadProperties(File file) {
        try {
            this.loadProperties(new FileInputStream(file));
        }
        catch (IOException iOException) {
            LOG.warn("Could not load application metadata from " + file.getAbsolutePath(), (Throwable)iOException);
        }
    }

    private void loadProperties(InputStream inputStream) throws IOException {
        this.properties.load(inputStream);
    }

    public String getApplicationVersion() {
        return this.get(APPLICATION_VERSION);
    }

    public String getEnvironment() {
        return this.get("griffon.env");
    }

    public String getRunMode() {
        return this.get("griffon.runmode");
    }

    public String getApplicationName() {
        return this.get(APPLICATION_NAME);
    }

    public String get(@Nonnull String string) {
        return this.properties.getProperty(GriffonNameUtils.requireNonBlank(string, "Argument 'key' must not be blank"));
    }

    @Nonnull
    public Set<String> keySet() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Object object : this.properties.keySet()) {
            linkedHashSet.add(String.valueOf(object));
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }
}

