/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.env;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum RunMode {
    STANDALONE,
    WEBSTART,
    APPLET,
    CUSTOM;

    public static final String KEY = "griffon.runmode";
    private static final String STANDALONE_RUNMODE_SHORT_NAME = "standalone";
    private static final String WEBSTART_RUNMODE_SHORT_NAME = "webstart";
    private static final String APPLET_RUNMODE_SHORT_NAME = "applet";
    private static final Map<String, String> MODE_NAME_MAPPINGS;
    private String name;

    public static boolean isSystemSet() {
        return System.getProperty(KEY) != null;
    }

    @Nullable
    public static RunMode resolveRunMode(@Nullable String string) {
        String string2 = MODE_NAME_MAPPINGS.get(string);
        if (string2 != null) {
            return RunMode.valueOf(string2.toUpperCase());
        }
        return null;
    }

    private static boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    @Nonnull
    public String getName() {
        if (this != CUSTOM || RunMode.isBlank(this.name)) {
            return this.toString().toLowerCase(Locale.getDefault());
        }
        return this.name;
    }

    public void setName(@Nullable String string) {
        this.name = string;
    }

    static {
        MODE_NAME_MAPPINGS = new LinkedHashMap<String, String>();
        MODE_NAME_MAPPINGS.put(STANDALONE_RUNMODE_SHORT_NAME, STANDALONE.getName());
        MODE_NAME_MAPPINGS.put(WEBSTART_RUNMODE_SHORT_NAME, WEBSTART.getName());
        MODE_NAME_MAPPINGS.put(APPLET_RUNMODE_SHORT_NAME, APPLET.getName());
    }
}

