/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.formatters;

import griffon.core.formatters.Formatter;
import griffon.core.formatters.ParseException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractFormatter<T>
implements Formatter<T> {
    protected static int parseHexInt(@Nonnull String string, @Nonnull Class<?> clazz) throws ParseException {
        try {
            return Integer.parseInt(String.valueOf(Objects.requireNonNull(string)).trim(), 16) & 0xFF;
        }
        catch (NumberFormatException numberFormatException) {
            throw AbstractFormatter.parseError(string, clazz, numberFormatException);
        }
    }

    protected static int parseHexInt(@Nonnull Number number) {
        return Objects.requireNonNull(number).intValue() & 0xFF;
    }

    protected static ParseException parseError(@Nullable Object object, @Nonnull Class<?> clazz) throws ParseException {
        throw new ParseException("Can't convert '" + object + "' into " + Objects.requireNonNull(clazz).getName());
    }

    protected static ParseException parseError(@Nullable Object object, @Nonnull Class<?> clazz, @Nonnull Exception exception) throws ParseException {
        throw new ParseException("Can't convert '" + object + "' into " + Objects.requireNonNull(clazz).getName(), Objects.requireNonNull(exception));
    }
}

