/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.annotation.Nullable;

public class BigDecimalFormatter
extends AbstractFormatter<BigDecimal> {
    public static final String PATTERN_CURRENCY = "currency";
    public static final String PATTERN_PERCENT = "percent";
    private final NumberFormat numberFormat;

    public BigDecimalFormatter() {
        this(null);
    }

    public BigDecimalFormatter(@Nullable String string) {
        if (GriffonNameUtils.isBlank(string)) {
            this.numberFormat = new DecimalFormat();
            ((DecimalFormat)this.numberFormat).setParseBigDecimal(true);
        } else if (PATTERN_CURRENCY.equalsIgnoreCase(string)) {
            this.numberFormat = NumberFormat.getCurrencyInstance();
        } else if (PATTERN_PERCENT.equalsIgnoreCase(string)) {
            this.numberFormat = NumberFormat.getPercentInstance();
        } else {
            this.numberFormat = new DecimalFormat(string);
            ((DecimalFormat)this.numberFormat).setParseBigDecimal(true);
        }
    }

    @Override
    @Nullable
    public String format(@Nullable BigDecimal bigDecimal) {
        return bigDecimal == null ? null : this.numberFormat.format(bigDecimal);
    }

    @Override
    @Nullable
    public BigDecimal parse(@Nullable String string) throws ParseException {
        if (GriffonNameUtils.isBlank(string)) {
            return null;
        }
        try {
            Number number = this.numberFormat.parse(string);
            if (number instanceof BigDecimal) {
                return (BigDecimal)number;
            }
            return new BigDecimal(number.longValue());
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException);
        }
    }
}

