/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.annotation.Nullable;

public class BigIntegerFormatter
extends AbstractFormatter<BigInteger> {
    public static final String PATTERN_CURRENCY = "currency";
    public static final String PATTERN_PERCENT = "percent";
    private final NumberFormat numberFormat;

    public BigIntegerFormatter() {
        this(null);
    }

    public BigIntegerFormatter(@Nullable String string) {
        if (GriffonNameUtils.isBlank(string)) {
            this.numberFormat = NumberFormat.getIntegerInstance();
        } else if (PATTERN_CURRENCY.equalsIgnoreCase(string)) {
            this.numberFormat = NumberFormat.getCurrencyInstance();
        } else if (PATTERN_PERCENT.equalsIgnoreCase(string)) {
            this.numberFormat = NumberFormat.getPercentInstance();
        } else {
            this.numberFormat = new DecimalFormat(string);
            this.numberFormat.setParseIntegerOnly(true);
            ((DecimalFormat)this.numberFormat).setParseBigDecimal(true);
        }
    }

    @Override
    @Nullable
    public String format(@Nullable BigInteger bigInteger) {
        return bigInteger == null ? null : this.numberFormat.format(bigInteger);
    }

    @Override
    @Nullable
    public BigInteger parse(@Nullable String string) throws ParseException {
        if (GriffonNameUtils.isBlank(string)) {
            return null;
        }
        try {
            Number number = this.numberFormat.parse(string);
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException);
        }
    }
}

