/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BooleanFormatter
extends AbstractFormatter<Boolean> {
    public static final String PATTERN_BOOL = "boolean";
    public static final String PATTERN_QUERY = "query";
    public static final String PATTERN_SWITCH = "switch";
    public static final String DEFAULT_PATTERN = "boolean";
    private static final String[] PATTERNS = new String[]{"boolean", "query", "switch"};
    public static final BooleanFormatter BOOL = new BooleanFormatter("boolean");
    public static final BooleanFormatter QUERY = new BooleanFormatter("query");
    public static final BooleanFormatter SWITCH = new BooleanFormatter("switch");
    private static final BooleanFormatter[] FORMATTERS = new BooleanFormatter[]{BOOL, QUERY, SWITCH};
    private final BooleanFormatterDelegate delegate;

    @Nonnull
    public static BooleanFormatter getInstance(@Nullable String string) {
        return new BooleanFormatter(string);
    }

    public BooleanFormatter() {
        this("boolean");
    }

    protected BooleanFormatter(@Nullable String string) {
        if ("boolean".equals(string)) {
            this.delegate = new BoolBooleanFormatterDelegate();
        } else if (PATTERN_QUERY.equals(string)) {
            this.delegate = new QueryBooleanFormatterDelegate();
        } else if (PATTERN_SWITCH.equals(string)) {
            this.delegate = new SwitchBooleanFormatterDelegate();
        } else if (GriffonNameUtils.isBlank(string)) {
            this.delegate = new BoolBooleanFormatterDelegate();
        } else {
            throw new IllegalArgumentException("Invalid pattern '" + string + "'. Valid patterns are " + Arrays.toString(PATTERNS));
        }
    }

    @Nonnull
    public String getPattern() {
        return this.delegate.getPattern();
    }

    @Nullable
    public static Boolean parseBoolean(@Nullable String string) throws ParseException {
        if (GriffonNameUtils.isBlank(string)) {
            return null;
        }
        for (BooleanFormatter booleanFormatter : FORMATTERS) {
            try {
                return booleanFormatter.parse(string);
            }
            catch (ParseException parseException) {
            }
        }
        throw BooleanFormatter.parseError(string, Boolean.class);
    }

    @Override
    @Nullable
    public String format(@Nullable Boolean bl) {
        return bl == null ? null : this.delegate.format(bl);
    }

    @Override
    @Nullable
    public Boolean parse(@Nullable String string) throws ParseException {
        return GriffonNameUtils.isBlank(string) ? null : this.delegate.parse(string);
    }

    private static class SwitchBooleanFormatterDelegate
    extends AbstractBooleanFormatterDelegate {
        private SwitchBooleanFormatterDelegate() {
            super(BooleanFormatter.PATTERN_SWITCH, new String[]{"off", "on"});
        }
    }

    private static class QueryBooleanFormatterDelegate
    extends AbstractBooleanFormatterDelegate {
        private QueryBooleanFormatterDelegate() {
            super(BooleanFormatter.PATTERN_QUERY, new String[]{"no", "yes"});
        }
    }

    private static class BoolBooleanFormatterDelegate
    extends AbstractBooleanFormatterDelegate {
        private BoolBooleanFormatterDelegate() {
            super("boolean", new String[]{"false", "true"});
        }
    }

    private static abstract class AbstractBooleanFormatterDelegate
    implements BooleanFormatterDelegate {
        private final String pattern;
        private final String[] tokens;

        private AbstractBooleanFormatterDelegate(String string, String[] stringArray) {
            this.pattern = string;
            this.tokens = stringArray;
        }

        @Override
        @Nonnull
        public String getPattern() {
            return this.pattern;
        }

        @Override
        @Nonnull
        public String format(@Nonnull Boolean bl) {
            Objects.requireNonNull(bl, "Can't format given Boolean because it's null");
            return bl != false ? this.tokens[1] : this.tokens[0];
        }

        @Override
        @Nonnull
        public Boolean parse(@Nonnull String string) throws ParseException {
            if (this.tokens[0].equalsIgnoreCase(string)) {
                return Boolean.FALSE;
            }
            if (this.tokens[1].equalsIgnoreCase(string)) {
                return Boolean.TRUE;
            }
            throw AbstractFormatter.parseError(string, Boolean.class);
        }
    }

    private static interface BooleanFormatterDelegate {
        @Nonnull
        public String getPattern();

        @Nonnull
        public String format(@Nonnull Boolean var1);

        @Nonnull
        public Boolean parse(@Nonnull String var1) throws ParseException;
    }
}

