/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.annotation.Nullable;

public class ByteFormatter
extends AbstractFormatter<Byte> {
    public static final String PATTERN_CURRENCY = "currency";
    public static final String PATTERN_PERCENT = "percent";
    private final NumberFormat numberFormat;

    public ByteFormatter() {
        this(null);
    }

    public ByteFormatter(@Nullable String string) {
        if (GriffonNameUtils.isBlank(string)) {
            this.numberFormat = NumberFormat.getIntegerInstance();
        } else if (PATTERN_CURRENCY.equalsIgnoreCase(string)) {
            this.numberFormat = NumberFormat.getCurrencyInstance();
        } else if (PATTERN_PERCENT.equalsIgnoreCase(string)) {
            this.numberFormat = NumberFormat.getPercentInstance();
        } else {
            this.numberFormat = new DecimalFormat(string);
            this.numberFormat.setParseIntegerOnly(true);
        }
    }

    @Override
    @Nullable
    public String format(@Nullable Byte by) {
        return by == null ? null : this.numberFormat.format(by);
    }

    @Override
    @Nullable
    public Byte parse(@Nullable String string) throws ParseException {
        if (GriffonNameUtils.isBlank(string)) {
            return null;
        }
        try {
            return this.numberFormat.parse(string).byteValue();
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException);
        }
    }
}

