/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CalendarFormatter
extends AbstractFormatter<Calendar> {
    private final SimpleDateFormat dateFormat;

    public CalendarFormatter() {
        this(null);
    }

    public CalendarFormatter(@Nullable String string) {
        this.dateFormat = GriffonNameUtils.isBlank(string) ? new SimpleDateFormat() : new SimpleDateFormat(string);
    }

    @Nonnull
    public String getPattern() {
        return this.dateFormat.toPattern();
    }

    @Override
    @Nullable
    public String format(@Nullable Calendar calendar) {
        return calendar == null ? null : this.dateFormat.format(calendar.getTime());
    }

    @Override
    @Nullable
    public Calendar parse(@Nullable String string) throws ParseException {
        if (GriffonNameUtils.isBlank(string)) {
            return null;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.dateFormat.parse(string));
            return calendar;
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException);
        }
    }
}

