/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DateFormatter
extends AbstractFormatter<Date> {
    private final SimpleDateFormat dateFormat;

    public DateFormatter() {
        this(null);
    }

    public DateFormatter(@Nullable String string) {
        this.dateFormat = GriffonNameUtils.isBlank(string) ? new SimpleDateFormat() : new SimpleDateFormat(string);
    }

    @Nonnull
    public String getPattern() {
        return this.dateFormat.toPattern();
    }

    @Override
    @Nullable
    public String format(@Nullable Date date) {
        return date == null ? null : this.dateFormat.format(date);
    }

    @Override
    @Nullable
    public Date parse(@Nullable String string) throws ParseException {
        if (GriffonNameUtils.isBlank(string)) {
            return null;
        }
        try {
            return this.dateFormat.parse(string);
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException);
        }
    }
}

