/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.annotation.Nullable;

public class DoubleFormatter
extends AbstractFormatter<Double> {
    public static final String PATTERN_CURRENCY = "currency";
    public static final String PATTERN_PERCENT = "percent";
    private final NumberFormat numberFormat;

    public DoubleFormatter() {
        this(null);
    }

    public DoubleFormatter(@Nullable String string) {
        this.numberFormat = GriffonNameUtils.isBlank(string) ? new DecimalFormat("#.0") : (PATTERN_CURRENCY.equalsIgnoreCase(string) ? NumberFormat.getCurrencyInstance() : (PATTERN_PERCENT.equalsIgnoreCase(string) ? NumberFormat.getPercentInstance() : new DecimalFormat(string)));
    }

    @Override
    @Nullable
    public String format(@Nullable Double d) {
        return d == null ? null : this.numberFormat.format(d);
    }

    @Override
    @Nullable
    public Double parse(@Nullable String string) throws ParseException {
        if (GriffonNameUtils.isBlank(string)) {
            return null;
        }
        try {
            return this.numberFormat.parse(string).doubleValue();
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException);
        }
    }
}

