/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.annotation.Nullable;

public class FloatFormatter
extends AbstractFormatter<Float> {
    public static final String PATTERN_CURRENCY = "currency";
    public static final String PATTERN_PERCENT = "percent";
    private final NumberFormat numberFormat;

    public FloatFormatter() {
        this(null);
    }

    public FloatFormatter(@Nullable String string) {
        this.numberFormat = GriffonNameUtils.isBlank(string) ? new DecimalFormat("#.0") : (PATTERN_CURRENCY.equalsIgnoreCase(string) ? NumberFormat.getCurrencyInstance() : (PATTERN_PERCENT.equalsIgnoreCase(string) ? NumberFormat.getPercentInstance() : new DecimalFormat(string)));
    }

    @Override
    @Nullable
    public String format(@Nullable Float f) {
        return f == null ? null : this.numberFormat.format(f);
    }

    @Override
    @Nullable
    public Float parse(@Nullable String string) throws ParseException {
        if (GriffonNameUtils.isBlank(string)) {
            return null;
        }
        try {
            return Float.valueOf(this.numberFormat.parse(string).floatValue());
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException);
        }
    }
}

