/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.annotation.Nullable;

public class ShortFormatter
extends AbstractFormatter<Short> {
    public static final String PATTERN_CURRENCY = "currency";
    public static final String PATTERN_PERCENT = "percent";
    private final NumberFormat numberFormat;

    public ShortFormatter() {
        this(null);
    }

    public ShortFormatter(@Nullable String string) {
        if (GriffonNameUtils.isBlank(string)) {
            this.numberFormat = NumberFormat.getIntegerInstance();
        } else if (PATTERN_CURRENCY.equalsIgnoreCase(string)) {
            this.numberFormat = NumberFormat.getCurrencyInstance();
        } else if (PATTERN_PERCENT.equalsIgnoreCase(string)) {
            this.numberFormat = NumberFormat.getPercentInstance();
        } else {
            this.numberFormat = new DecimalFormat(string);
            this.numberFormat.setParseIntegerOnly(true);
        }
    }

    @Override
    @Nullable
    public String format(@Nullable Short s) {
        return s == null ? null : this.numberFormat.format(s);
    }

    @Override
    @Nullable
    public Short parse(@Nullable String string) throws ParseException {
        if (GriffonNameUtils.isBlank(string)) {
            return null;
        }
        try {
            return this.numberFormat.parse(string).shortValue();
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException);
        }
    }
}

