/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.injection;

import griffon.core.injection.Binding;
import java.lang.annotation.Annotation;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Key<T> {
    private static final String ERROR_SOURCE_NULL = "Argument 'source' must not be null";
    private static final String ERROR_ANNOTATION_NULL = "Argument 'annotation' must not be null";
    private static final String ERROR_ANNOTATION_TYPE_NULL = "Argument 'annotationType' must not be null";
    private final Class<T> source;
    private Class<? extends Annotation> annotationType;
    private Annotation annotation;

    private Key(@Nonnull Class<T> clazz) {
        this.source = Objects.requireNonNull(clazz, ERROR_SOURCE_NULL);
    }

    private Key(@Nonnull Class<T> clazz, @Nonnull Annotation annotation) {
        this.source = Objects.requireNonNull(clazz, ERROR_SOURCE_NULL);
        this.annotation = Objects.requireNonNull(annotation, ERROR_ANNOTATION_NULL);
        this.annotationType = annotation.getClass();
    }

    private Key(@Nonnull Class<T> clazz, @Nonnull Class<? extends Annotation> clazz2) {
        this.source = Objects.requireNonNull(clazz, ERROR_SOURCE_NULL);
        this.annotationType = Objects.requireNonNull(clazz2, ERROR_ANNOTATION_TYPE_NULL);
    }

    @Nonnull
    public Class<?> getSource() {
        return this.source;
    }

    @Nullable
    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    @Nullable
    public Annotation getAnnotation() {
        return this.annotation;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Key key = (Key)object;
        if (this.annotation != null) {
            return this.source.equals(key.source) && this.annotation.equals(key.annotation);
        }
        return this.source.equals(key.source) && !(this.annotationType == null ? key.annotationType != null : !this.annotationType.equals(key.annotationType));
    }

    public int hashCode() {
        int n = this.source.hashCode();
        n = this.annotation != null ? 31 * n + this.annotation.hashCode() : 31 * n + (this.annotationType != null ? this.annotationType.hashCode() : 0);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Key{");
        stringBuilder.append("source=").append(this.source);
        stringBuilder.append(", annotation=").append(this.annotation);
        stringBuilder.append(", annotationType=").append(this.annotationType);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Nonnull
    public static <T> Key<T> of(@Nonnull Class<T> clazz) {
        return new Key<T>(clazz);
    }

    @Nonnull
    public static <T> Key<T> of(@Nonnull Class<T> clazz, @Nonnull Annotation annotation) {
        return new Key<T>(clazz, annotation);
    }

    @Nonnull
    public static <T> Key<T> of(@Nonnull Class<T> clazz, @Nonnull Class<? extends Annotation> clazz2) {
        return new Key<T>(clazz, clazz2);
    }

    @Nonnull
    public static <T> Key<T> of(@Nonnull Binding<T> binding) {
        return binding.getClassifier() != null ? new Key<T>(binding.getSource(), binding.getClassifier()) : (binding.getClassifierType() != null ? new Key<T>(binding.getSource(), binding.getClassifierType()) : new Key<T>(binding.getSource()));
    }
}

