/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.injection;

import java.lang.annotation.Annotation;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Qualified<T> {
    private Annotation qualifier;
    private final T instance;

    public Qualified(@Nonnull T t, @Nullable Annotation annotation) {
        this.instance = Objects.requireNonNull(t, "Argument 'instance' must not be null");
        this.qualifier = annotation;
    }

    @Nullable
    public Annotation getQualifier() {
        return this.qualifier;
    }

    @Nonnull
    public T getInstance() {
        return this.instance;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Qualified qualified = (Qualified)object;
        return this.instance.equals(qualified.instance) && !(this.qualifier == null ? qualified.qualifier != null : !this.qualifier.equals(qualified.qualifier));
    }

    public int hashCode() {
        int n = this.qualifier != null ? this.qualifier.hashCode() : 0;
        n = 31 * n + this.instance.hashCode();
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Qualified{");
        stringBuilder.append("qualifier=").append(this.qualifier);
        stringBuilder.append(", instance=").append(this.instance);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

