/*
 * Decompiled with CFR 0.152.
 */
package griffon.exceptions;

import griffon.core.artifact.GriffonArtifact;
import griffon.core.artifact.GriffonClass;
import griffon.exceptions.GriffonException;
import javax.annotation.Nonnull;

public class ArtifactNotFoundException
extends GriffonException {
    private static final long serialVersionUID = -7881105306242340254L;

    public ArtifactNotFoundException(@Nonnull Throwable throwable) {
        super("Could not find artifact", ArtifactNotFoundException.checkNonNull(throwable, "cause"));
    }

    public ArtifactNotFoundException(@Nonnull Class<?> clazz) {
        super(ArtifactNotFoundException.format(clazz));
    }

    public ArtifactNotFoundException(@Nonnull GriffonClass griffonClass, @Nonnull Throwable throwable) {
        super(ArtifactNotFoundException.format(griffonClass), ArtifactNotFoundException.checkNonNull(throwable, "cause"));
    }

    public ArtifactNotFoundException(@Nonnull Class<? extends GriffonArtifact> clazz, @Nonnull String string) {
        super(ArtifactNotFoundException.format(clazz, string));
    }

    private static String format(GriffonClass griffonClass) {
        return "Could not find artifact for " + ArtifactNotFoundException.checkNonNull(griffonClass, "griffonClass").getPropertyName();
    }

    private static String format(Class<?> clazz) {
        return "Could not find artifact for " + ArtifactNotFoundException.checkNonNull(clazz, "clazz").getName();
    }

    private static String format(Class<? extends GriffonArtifact> clazz, String string) {
        return "Could not find artifact of type " + ArtifactNotFoundException.checkNonNull(clazz, "clazz").getName() + " named " + ArtifactNotFoundException.checkNonBlank(string, "name");
    }
}

