/*
 * Decompiled with CFR 0.152.
 */
package griffon.exceptions;

import griffon.exceptions.MethodInvocationException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InstanceMethodInvocationException
extends MethodInvocationException {
    private static final long serialVersionUID = -2325571968606780435L;

    public InstanceMethodInvocationException(@Nonnull Object object, @Nonnull String string, @Nullable Object[] objectArray) {
        super(InstanceMethodInvocationException.formatArguments(object, string, objectArray));
    }

    public InstanceMethodInvocationException(@Nonnull Object object, @Nonnull String string, @Nullable Object[] objectArray, @Nonnull Throwable throwable) {
        super(InstanceMethodInvocationException.formatArguments(object, string, objectArray), throwable);
    }

    public InstanceMethodInvocationException(@Nonnull Object object, @Nonnull Method method) {
        super(InstanceMethodInvocationException.formatArguments(object, method));
    }

    public InstanceMethodInvocationException(@Nonnull Object object, @Nonnull Method method, @Nonnull Throwable throwable) {
        super(InstanceMethodInvocationException.formatArguments(object, method), throwable);
    }

    @Nonnull
    private static String formatArguments(@Nonnull Object object, @Nonnull String string, @Nullable Object[] objectArray) {
        InstanceMethodInvocationException.checkNonNull(object, "instance");
        InstanceMethodInvocationException.checkNonBlank(string, "methodName");
        StringBuilder stringBuilder = new StringBuilder("An error occurred while invoking instance method ").append(object.getClass().getName()).append(".").append(string).append("(");
        boolean bl = true;
        for (Class<?> clazz : InstanceMethodInvocationException.convertToTypeArray(objectArray)) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            if (clazz == null) {
                stringBuilder.append(Object.class.getName());
                continue;
            }
            stringBuilder.append(clazz.getName());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Nonnull
    protected static String formatArguments(@Nonnull Object object, @Nonnull Method method) {
        InstanceMethodInvocationException.checkNonNull(object, "instance");
        InstanceMethodInvocationException.checkNonNull(method, "method");
        StringBuilder stringBuilder = new StringBuilder("An error occurred while invoking instance method ").append(object.getClass().getName()).append(".").append(method.getName()).append("(");
        boolean bl = true;
        for (Class<?> clazz : method.getParameterTypes()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(clazz.getName());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

