/*
 * Decompiled with CFR 0.152.
 */
package griffon.exceptions;

import griffon.exceptions.MethodInvocationException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StaticMethodInvocationException
extends MethodInvocationException {
    private static final long serialVersionUID = 7806081622952446099L;

    public StaticMethodInvocationException(@Nonnull Class<?> clazz, @Nonnull String string, @Nullable Object[] objectArray) {
        super(StaticMethodInvocationException.formatArguments(clazz, string, objectArray));
    }

    public StaticMethodInvocationException(@Nonnull Class<?> clazz, @Nonnull String string, @Nullable Object[] objectArray, @Nonnull Throwable throwable) {
        super(StaticMethodInvocationException.formatArguments(clazz, string, objectArray), throwable);
    }

    @Nonnull
    private static String formatArguments(@Nonnull Class<?> clazz, @Nonnull String string, @Nullable Object[] objectArray) {
        StaticMethodInvocationException.checkNonNull(clazz, "class");
        StaticMethodInvocationException.checkNonBlank(string, "methodName");
        StringBuilder stringBuilder = new StringBuilder("An error occurred while invoking static method ").append(clazz.getName()).append(".").append(string).append("(");
        boolean bl = true;
        for (Class<?> clazz2 : StaticMethodInvocationException.convertToTypeArray(objectArray)) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(clazz2.getName());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

