/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractMapResourceBundle
extends ResourceBundle {
    protected final Map<String, Object> entries = new LinkedHashMap<String, Object>();
    protected volatile Set<String> keys;

    public AbstractMapResourceBundle() {
        this.initialize(this.entries);
        this.initializeKeys();
    }

    protected abstract void initialize(@Nonnull Map<String, Object> var1);

    protected void initializeKeys() {
        this.keys = ConfigUtils.collectKeys(this.entries);
    }

    @Override
    @Nullable
    protected final Object handleGetObject(@Nonnull String string) {
        return ConfigUtils.getConfigValue(this.entries, GriffonNameUtils.requireNonBlank(string, "Argument 'key' must not be blank"));
    }

    @Override
    @Nonnull
    public final Enumeration<String> getKeys() {
        return new IteratorAsEnumeration<String>(this.keys.iterator());
    }

    @Override
    public Set<String> keySet() {
        return this.keys;
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.keys;
    }

    private static class IteratorAsEnumeration<E>
    implements Enumeration<E> {
        private final Iterator<E> iterator;

        public IteratorAsEnumeration(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public E nextElement() {
            return this.iterator.next();
        }
    }
}

