/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.inject.BindTo;
import griffon.inject.DependsOn;
import griffon.inject.Typed;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import griffon.util.MethodDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Qualifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationUtils.class);
    private static final String ERROR_CLASS_NULL = "Argument 'class' must not be null";
    private static final String ERROR_SUFFIX_NULL = "Argument 'suffix' must not be null";
    private static final String ERROR_INSTANCE_NULL = "Argument 'instance' must not be null";
    private static final String ERROR_ANNOTATION_TYPE_NULL = "Argument 'annotationType' must not be null";

    private AnnotationUtils() {
    }

    @Nonnull
    public static List<Annotation> harvestQualifiers(@Nonnull Class<?> clazz) {
        Annotation[] annotationArray;
        Objects.requireNonNull(clazz, ERROR_CLASS_NULL);
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (Annotation annotation : annotationArray = clazz.getAnnotations()) {
            Named named;
            if (!AnnotationUtils.isAnnotatedWith(annotation, Qualifier.class) || BindTo.class.isAssignableFrom(annotation.getClass())) continue;
            if (Named.class.isAssignableFrom(annotation.getClass()) && GriffonNameUtils.isBlank((named = (Named)annotation).value())) {
                arrayList.add((Annotation)AnnotationUtils.named(GriffonNameUtils.getPropertyName(clazz)));
                continue;
            }
            arrayList.add(annotation);
        }
        return arrayList;
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(@Nonnull Class<?> clazz, @Nonnull Class<A> clazz2) {
        Objects.requireNonNull(clazz, ERROR_CLASS_NULL);
        Objects.requireNonNull(clazz2, ERROR_ANNOTATION_TYPE_NULL);
        while (clazz != null) {
            A a = AnnotationUtils.findAnnotation(clazz.getAnnotations(), clazz2);
            if (a != null) {
                return a;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(@Nonnull Annotation[] annotationArray, @Nonnull Class<A> clazz) {
        Objects.requireNonNull(annotationArray, "Argument 'annotations' must not be null");
        Objects.requireNonNull(clazz, ERROR_ANNOTATION_TYPE_NULL);
        for (Annotation annotation : annotationArray) {
            if (!clazz.isAssignableFrom(annotation.getClass())) continue;
            return (A)annotation;
        }
        return null;
    }

    public static boolean isAnnotatedWith(@Nonnull Object object, @Nonnull Class<? extends Annotation> clazz) {
        return AnnotationUtils.isAnnotatedWith(Objects.requireNonNull(object, ERROR_INSTANCE_NULL).getClass(), clazz);
    }

    public static boolean isAnnotatedWith(@Nonnull Class<?> clazz, @Nonnull Class<? extends Annotation> clazz2) {
        Objects.requireNonNull(clazz, ERROR_CLASS_NULL);
        Objects.requireNonNull(clazz2, ERROR_ANNOTATION_TYPE_NULL);
        while (clazz != null) {
            for (Annotation annotation : clazz.getAnnotations()) {
                if (!clazz2.equals(annotation.annotationType())) continue;
                return true;
            }
            for (Class<?> clazz3 : clazz.getInterfaces()) {
                if (!AnnotationUtils.isAnnotatedWith(clazz3, clazz2)) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    @Nonnull
    public static <T> T requireAnnotation(@Nonnull T t, @Nonnull Class<? extends Annotation> clazz) {
        if (!AnnotationUtils.isAnnotatedWith(t, clazz)) {
            throw new IllegalArgumentException("Instance of " + t.getClass() + " is not annotated with " + clazz.getName());
        }
        return t;
    }

    @Nonnull
    public static <T> Class<T> requireAnnotation(@Nonnull Class<T> clazz, @Nonnull Class<? extends Annotation> clazz2) {
        if (!AnnotationUtils.isAnnotatedWith(clazz, clazz2)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not annotated with " + clazz2.getName());
        }
        return clazz;
    }

    @Nonnull
    public static String[] getDependsOn(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_INSTANCE_NULL);
        DependsOn dependsOn = object.getClass().getAnnotation(DependsOn.class);
        return dependsOn != null ? dependsOn.value() : new String[]{};
    }

    @Nonnull
    public static String nameFor(@Nonnull Object object) {
        Objects.requireNonNull(object, ERROR_INSTANCE_NULL);
        Named named = object.getClass().getAnnotation(Named.class);
        if (named != null && !GriffonNameUtils.isBlank(named.value())) {
            return named.value();
        }
        return object.getClass().getName();
    }

    @Nonnull
    public static String nameFor(@Nonnull Field field) {
        Objects.requireNonNull(field, "Argument 'field' must not be null");
        Named named = field.getAnnotation(Named.class);
        if (named != null && !GriffonNameUtils.isBlank(named.value())) {
            return named.value();
        }
        return field.getType().getName();
    }

    @Nonnull
    public static String[] namesFor(@Nonnull Field field) {
        Objects.requireNonNull(field, "Argument 'field' must not be null");
        ArrayList<String> arrayList = new ArrayList<String>();
        Named named = field.getAnnotation(Named.class);
        if (named != null && !GriffonNameUtils.isBlank(named.value())) {
            arrayList.add(named.value());
        } else {
            arrayList.add(field.getName());
        }
        arrayList.add(field.getType().getName());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Nonnull
    public static String nameFor(@Nonnull Method method) {
        Objects.requireNonNull(method, "Argument 'setterMethod' must not be null");
        Class<?>[] classArray = method.getParameterTypes();
        GriffonClassUtils.requireState(classArray != null && classArray.length > 0, "Argument 'setterMethod' must have at least one parameter. " + MethodDescriptor.forMethod(method));
        Named named = AnnotationUtils.findAnnotation(AnnotationUtils.annotationsOfMethodParameter(method, 0), Named.class);
        if (named != null && !GriffonNameUtils.isBlank(named.value())) {
            return named.value();
        }
        return classArray[0].getName();
    }

    @Nonnull
    public static String[] namesFor(@Nonnull Method method) {
        Objects.requireNonNull(method, "Argument 'setterMethod' must not be null");
        Class<?>[] classArray = method.getParameterTypes();
        GriffonClassUtils.requireState(classArray != null && classArray.length > 0, "Argument 'setterMethod' must have at least one parameter. " + MethodDescriptor.forMethod(method));
        ArrayList<String> arrayList = new ArrayList<String>();
        Named named = AnnotationUtils.findAnnotation(AnnotationUtils.annotationsOfMethodParameter(method, 0), Named.class);
        if (named != null && !GriffonNameUtils.isBlank(named.value())) {
            arrayList.add(named.value());
        } else if (GriffonClassUtils.isSetterMethod(method)) {
            arrayList.add(GriffonNameUtils.uncapitalize(method.getName().substring(3)));
        } else {
            arrayList.add(GriffonNameUtils.uncapitalize(method.getName()));
        }
        arrayList.add(classArray[0].getName());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Nonnull
    public static Annotation[] annotationsOfMethodParameter(@Nonnull Method method, int n) {
        Objects.requireNonNull(method, "Argument 'method' must not be null");
        Class<?>[] classArray = method.getParameterTypes();
        GriffonClassUtils.requireState(classArray != null && classArray.length > n, "Index " + n + " is out of bounds");
        return method.getParameterAnnotations()[n];
    }

    @Nonnull
    public static <T> Map<String, T> mapInstancesByName(@Nonnull Collection<T> collection, @Nonnull String string) {
        LinkedHashMap<String, T> linkedHashMap = new LinkedHashMap<String, T>();
        for (T t : collection) {
            linkedHashMap.put(GriffonNameUtils.getLogicalPropertyName(AnnotationUtils.nameFor(t), string), t);
        }
        return linkedHashMap;
    }

    @Nonnull
    public static <T> Map<String, T> sortByDependencies(@Nonnull Collection<T> collection, @Nonnull String string, @Nonnull String string2) {
        return AnnotationUtils.sortByDependencies(collection, string, string2, Collections.emptyList());
    }

    @Nonnull
    public static <T> Map<String, T> sortByDependencies(@Nonnull Collection<T> collection, @Nonnull String string, @Nonnull String string2, @Nonnull List<String> list) {
        Cloneable cloneable;
        Cloneable cloneable2;
        Objects.requireNonNull(collection, "Argument 'instances' must not be null");
        Objects.requireNonNull(string, ERROR_SUFFIX_NULL);
        Objects.requireNonNull(string2, "Argument 'type' must not be null");
        Objects.requireNonNull(list, "Argument 'order' must not be null");
        Map<String, Object> map = AnnotationUtils.mapInstancesByName(collection, string);
        LinkedHashMap<String, T> linkedHashMap = new LinkedHashMap<String, T>();
        linkedHashMap.putAll(map);
        if (!list.isEmpty()) {
            cloneable2 = new LinkedHashMap<String, T>(map);
            cloneable = new LinkedHashMap();
            for (String object : list) {
                if (!cloneable2.containsKey(object)) continue;
                cloneable.put(object, cloneable2.remove(object));
            }
            cloneable.putAll(cloneable2);
            linkedHashMap.clear();
            linkedHashMap.putAll((Map<String, T>)((Object)cloneable));
        }
        cloneable2 = new ArrayList();
        cloneable = new LinkedHashSet();
        while (!linkedHashMap.isEmpty()) {
            Object[] objectArray;
            String string3;
            int n = 0;
            LOG.debug("Current {} order is {}", (Object)string2, map.keySet());
            Iterator iterator = linkedHashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                string3 = (String)entry.getKey();
                objectArray = AnnotationUtils.getDependsOn(entry.getValue());
                LOG.trace("Processing {} '{}'", (Object)string2, (Object)string3);
                LOG.trace("  depends on '{}'", (Object)Arrays.toString(objectArray));
                if (objectArray.length != 0) {
                    LOG.trace("  checking {} '{}' dependencies ({})", new Object[]{string2, string3, objectArray.length});
                    boolean bl = false;
                    Object[] objectArray2 = objectArray;
                    int n2 = objectArray2.length;
                    for (int i = 0; i < n2; ++i) {
                        Object object = objectArray2[i];
                        LOG.trace("  checking {} '{}' dependencies: ", new Object[]{string2, string3, object});
                        if (!cloneable.contains(object)) {
                            LOG.trace("  skipped {} '{}', since dependency '{}' not yet added", new Object[]{string2, string3, object});
                            bl = true;
                            break;
                        }
                        LOG.trace("  {} '{}' dependency '{}' already added", new Object[]{string2, string3, object});
                    }
                    if (bl) continue;
                }
                LOG.trace("  adding {} '{}', since all dependencies have been added", (Object)string2, (Object)string3);
                cloneable2.add(entry.getValue());
                cloneable.add(string3);
                iterator.remove();
                ++n;
            }
            if (n == 0) {
                LOG.warn("  unresolved {} dependencies detected", (Object)string2);
                LOG.warn("  continuing with original {} order", (Object)string2);
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    string3 = (String)entry.getKey();
                    objectArray = AnnotationUtils.getDependsOn(entry.getValue());
                    LOG.warn("  {} {} ", (Object)string2, (Object)string3);
                    if (objectArray.length != 0) {
                        for (Object object : objectArray) {
                            LOG.warn("    depends on {}", object);
                        }
                        continue;
                    }
                    LOG.warn("  problem while resolving dependencies.");
                    LOG.warn("  unable to resolve dependency hierarchy.");
                }
                break;
            }
            if (cloneable2.size() != map.size()) continue;
            LOG.trace("{} dependency ordering complete", (Object)string2);
            break;
        }
        map = AnnotationUtils.mapInstancesByName(cloneable2, string);
        LOG.debug("computed {} order is {}", (Object)string2, map.keySet());
        return map;
    }

    @Nonnull
    public static Named named(@Nonnull String string) {
        return new NamedImpl(Objects.requireNonNull(string, "Argument 'name' must not be null"));
    }

    @Nonnull
    public static Typed typed(@Nonnull Class<?> clazz) {
        return new TypedImpl(Objects.requireNonNull(clazz, ERROR_CLASS_NULL));
    }

    @Nonnull
    public static BindTo bindto(@Nonnull Class<?> clazz) {
        return new BindToImpl(Objects.requireNonNull(clazz, ERROR_CLASS_NULL));
    }

    private static class BindToImpl
    implements BindTo,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Class<?> value;

        public BindToImpl(Class<?> clazz) {
            this.value = Objects.requireNonNull(clazz, "value");
        }

        @Override
        public Class<?> value() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof BindTo)) {
                return false;
            }
            BindTo bindTo = (BindTo)object;
            return this.value.equals(bindTo.value());
        }

        @Override
        public String toString() {
            return "@" + BindTo.class.getName() + "(value=" + this.value + ")";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return BindTo.class;
        }
    }

    private static class TypedImpl
    implements Typed,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Class<?> value;

        public TypedImpl(Class<?> clazz) {
            this.value = Objects.requireNonNull(clazz, "value");
        }

        @Override
        public Class<?> value() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Typed)) {
                return false;
            }
            Typed typed = (Typed)object;
            return this.value.equals(typed.value());
        }

        @Override
        public String toString() {
            return "@" + Typed.class.getName() + "(value=" + this.value + ")";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Typed.class;
        }
    }

    private static class NamedImpl
    implements Named,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final String value;

        public NamedImpl(String string) {
            this.value = Objects.requireNonNull(string, "value");
        }

        public String value() {
            return this.value;
        }

        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Named)) {
                return false;
            }
            Named named = (Named)object;
            return this.value.equals(named.value());
        }

        public String toString() {
            return "@" + Named.class.getName() + "(value=" + this.value + ")";
        }

        public Class<? extends Annotation> annotationType() {
            return Named.class;
        }
    }
}

